function getCookie(name) {
  var value = "; " + document.cookie;
  var parts = value.split("; " + name + "=");
  if (parts.length == 2) return parts.pop().split(";").shift();
}

angular.module('whatsspy-translate', ['pascalprecht.translate']).
config(['$translateProvider', function ($translateProvider) {
    $translateProvider.translations('en', {
    /* PLEASE NOTE that spaces etc. are all of importance here. You also must escape ' (by using \') */
    /* Use your gitlab/real name here to identify your work */
    TRANSLATOR: '',
    MENU_LOGIN: 'Login',
    MENU_OVERVIEW: 'Overview',
    MENU_COMPARE: 'Compare',
    MENU_TIMELINE: 'Timeline',
    MENU_STATS: 'Statistics',
    MENU_ABOUT: 'About / Help',
    MENU_USER: 'Public user',
    MENU_GROUP: 'Public group',
    MENU_LOADING: 'Loading new data ...',
    MENU_STATUS: 'status',
    MENU_TRACKER_ONLINE: 'Tracker online',
    MENU_TRACKER_OFFLINE: 'Tracker offline',
    MENU_TRACKER_NOAUTH: 'not authenticated',
    MENU_TRACKER_USERS: 'users',
    MENU_TRACKER_REFRESH: 'Click to refresh the data loaded into the web-app.',
    MENU_POC: 'Proof of Concept',
    FOOTER_VERSION: 'Version',
    FOOTER_V_BEHIND: 'Behind',
    LOGIN_WELCOME: 'Welcome!',
    LOGIN_WELCOME_MSG: 'Welcome to the WhatsSpy Public PoC! Before you start tracking please read the',
    LOGIN_LICENSE: 'license',
    LOGIN_LOGIN_HEAD: 'Login',
    LOGIN_AUTH_NOTIFY: 'It seems you are not yet authenticated. Please login to view and manage the tracker.',
    LOGIN_PASS_FIELD: 'Password',
    LOGIN_SIGN_IN_BTN: 'Sign in',
    LOGIN_RESET_BTN: 'Reset',
    LOGIN_PASS_PLACEHOLDER: 'password ...',
    TOKEN_INVALID: 'Invalid token:',
    OVERVIEW_TOKEN_INVALID: 'You are not allowed to view this user because the token is or became invalid.',
    OVERVIEW_TOKEN_INFO_STRONG: 'Shared user profile:',
    OVERVIEW_TOKEN_INFO: 'This is a shared user profile created by the hoster of this WhatsSpy Public instance. The timeline contains just a snapshot of the last statuses.',
    OVERVIEW_FILTERS: 'Filters',
    OVERVIEW_FILTER_PHONE: 'Search by phone number ...',
    OVERVIEW_FILTER_NAME_TITLE: 'Use name|name to filter on multiple names.',
    OVERVIEW_FILTER_NAME: 'Search by name ...',
    OVERVIEW_INFO_STATUS: 'The system is checking all statuses',
    OVERVIEW_INFO_STATUS_FROM: 'from',
    OVERVIEW_INFO_STATUS_CONTACTS: 'contacts',
    OVERVIEW_INFO_STATUS_SINCE: 'since',
    OVERVIEW_INFO_PRIV: 'Contacts that have "last seen" set to "nobody" will be',
    OVERVIEW_INFO_PRIV_LINK: 'tracked anyway',
    OVERVIEW_INFO_LIVE: 'The information on this page is not live, you can refresh this page by clicking the gray timestamp in the "status" panel.',
    OVERVIEW_INFO_TIMESPAN: 'Beside the timeline, all information is from since you started tracking this contact (unless noted otherwise).',
    OVERVIEW_INFO_VERIFY: 'contacts will be verified within 5-10 minutes,',
    OVERVIEW_INFO_RELOAD: 'reload data',
    OVERVIEW_INFO_RELOAD_2: 'to check again.',
    OVERVIEW_ADD: 'Add Contact',
    OVERVIEW_IMPORT: 'Import Google Contacts',
    OVERVIEW_MANAGE_GROUPS: 'Manage groups',
    OVERVIEW_MANAGE_PERF: 'Performance options',
    OVERVIEW_EXPAND: 'Expand view',
    OVERVIEW_COLLAPSE: 'Collapse view',
    OVERVIEW_EDIT: 'Edit',
    OVERVIEW_CONTACT_SINCE: 'tracking since',
    OVERVIEW_CONTACT_LASTSEEN: 'last seen',
    OVERVIEW_CONTACT_NOTIF: 'notifications enabled',
    OVERVIEW_CONTACT_SHARING: 'profile sharing enabled',
    OVERVIEW_NO_INFO: 'No information available ..',
    OVERVIEW_CLICK_LOAD: 'Click to load data',
    OVERVIEW_CLICK_LOAD_TIMELINE: 'Load timeline',
    OVERVIEW_CONTACT_H_ANALYTICS: 'Analytics / Information',
    OVERVIEW_CONTACT_ANALYTICS_OVERVIEW: 'Overview',
    OVERVIEW_CONTACT_ANALYTICS_OPENOVERVIEW: 'Opened overview',
    OVERVIEW_CONTACT_ANALYTICS_TIME_OVERVIEW: 'Time overview',
    OVERVIEW_CONTACT_ANALYTICS_STATUS: 'Status Messages',
    OVERVIEW_CONTACT_ANALYTICS_PICS: 'Profile pictures',
    OVERVIEW_CONTACT_OPENED_H: 'Opened WhatsApp client',
    OVERVIEW_CONTACT_TABLE_1D: '(24h) today',
    OVERVIEW_CONTACT_TABLE_7D: '(07d) last 7 days',
    OVERVIEW_CONTACT_TABLE_14D: '(14d) last two weeks',
    OVERVIEW_CONTACT_TABLE_31D: '(31d) last month',
    OVERVIEW_CONTACT_TABLE_xD: '(---) all time',
    OVERVIEW_CONTACT_TRACKING_SINCE: 'Tracking since',
    OVERVIEW_CONTACT_TIME_SPENT_WA: 'Time spent on WhatsApp',
    OVERVIEW_CONTACT_LOADING_INFO: 'Loading information ...',
    OVERVIEW_CONTACT_SWITCH_HOUR_VIEW: 'Show per hour',
    OVERVIEW_CONTACT_SWITCH_WEEKDAY_VIEW: 'Show per weekday',
    OVERVIEW_CONTACT_H_OPENING_WA_WEEKDAY: 'Opening WhatsApp per weekday',
    OVERVIEW_CONTACT_H_OPENING_WA_HOUR: 'Opening WhatsApp per hour',
    OVERVIEW_CONTACT_H_TIME_WA_WEEKDAY: 'Time on WhatsApp per weekday',
    OVERVIEW_CONTACT_H_TIME_WA_HOUR: 'Time on WhatsApp per hour',
    OVERVIEW_CONTACT_H_PRIV_STATUS: 'Privacy / Online status',
    OVERVIEW_CONTACT_PRIV_STATUS: 'Privacy',
    OVERVIEW_CONTACT_ONLINE_EVENTS: 'Online events',
    OVERVIEW_CONTACT_H_LASTSEEN: 'Last seen',
    OVERVIEW_CONTACT_TIMES: 'times',
    OVERVIEW_PRIVACY_SETTINGS_PUBLIC: 'everyone',
    OVERVIEW_PRIVACY_SETTINGS_FRIENDS: 'contacts*',
    OVERVIEW_PRIVACY_LAST_CHANGE: 'changed to',
    OVERVIEW_PRIVACY_LAST_CHANGE_AT: 'at',
    OVERVIEW_PRIVACY_H_PROF_PIC: 'Profile pic',
    OVERVIEW_PRIVACY_H_STATUS: 'Status messages',
    OVERVIEW_PRIVACY_TRACK_NOTICE: 'Profile picture and status message are checked every 2 hours.',
    OVERVIEW_PRIVACY_ASSUMPTION: 'Assuming this user does not have the tracker number in his contact list. If this is the case \'contacts only\' will be interpreted as \'everyone\' in this view.',
    OVERVIEW_LOG_FROM: 'from',
    OVERVIEW_LOG_TILL: 'till',
    OVERVIEW_LOG_NOW: 'now',
    OVERVIEW_NO_ACC: 'No tracking accounts ..',
    OVERVIEW_ADD_CONTACT_H: 'Add contact by phone number',
    OVERVIEW_ADD_CONTACT_PHONE: 'Phone number',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_COUNTRYCODE: 'countrycode ...',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_PHONE: 'phone number ...',
    OVERVIEW_ADD_CONTACT_NAME: 'Contact name',
    OVERVIEW_ADD_CONTACT_GROUP: 'Groups',
    OVERVIEW_ADD_CONTACT_NOTICE: 'The new contact will be verified as an WhatsApp user and added to the tracker within 5-10 minutes. After this you can find the contact in the overview list.',
    OVERVIEW_ADD_CONTACT_ADD: 'Add contact',
    OVERVIEW_ADD_CONTACT_CLOSE: 'Close',
    OVERVIEW_EDIT_CONTACT_H: 'Edit contact name',
    OVERVIEW_EDIT_CONTACT_PHONE: 'Phone number',
    OVERVIEW_EDIT_CONTACT_NAME: 'Contact name',
    OVERVIEW_EDIT_CONTACT_NAME_PLACEHOLDER: '(optional) name of contact',
    OVERVIEW_EDIT_CONTACT_GROUPS: 'Groups',
    OVERVIEW_EDIT_CONTACT_PROFILESHARE: 'Share profile',
    OVERVIEW_EDIT_CONTACT_GENERATE_TOKEN: 'Generate',
    OVERVIEW_EDIT_CONTACT_RESET_TOKEN: 'Reset',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO: 'Sharing profile URL\'s will only work if WhatsSpy Public is available from the internet.',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO2: 'Click on the token to copy the link. The generation of tokens does not have to be saved.',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS: 'Notifications',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_ONLINE: 'Coming online',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_STATUSMSG: 'Status message change',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PROFPIC: 'Profile picture change',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PRIV: 'Privacy setting changes',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS: 'There are no notification agents configured in',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS_CONFIG: 'config.php',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_MISSING: 'Check config.example.php in case you are missing these options.',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_SENDING: 'Sending notifications for user actions via',
    OVERVIEW_AND: 'and',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE: 'Show timeline notifications (if open)',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE_EXPL: 'Notification sound used in the timeline for this user.',
    OVERVIEW_EDIT_CONTACT_SAVE: 'Save contact',
    OVERVIEW_EDIT_CONTACT_INACTIVE: 'Set inactive',
    OVERVIEW_EDIT_CONTACT_DELETE: 'Delete contact (!)',
    OVERVIEW_EDIT_CONTACT_DETELE_TITLE: 'Delete all information of this contact, including any status records.',
    OVERVIEW_EDIT_CONTACT_INACTIVE_TITLE: 'Do not track the user, but keep any status/privacy records of this person. This change can take up to an hour to take effect in the tracker.',
    OVERVIEW_GROUPS_H: 'Manage Groups',
    OVERVIEW_GROUPS_EXISTING: 'Existing groups',
    OVERVIEW_GROUPS_USERS: 'Users:',
    OVERVIEW_GROUPS_STATSEN: 'Statistics sharing enabled',
    OVERVIEW_GROUPS_STATSDIS: 'Sharing disabled*',
    OVERVIEW_GROUPS_NONE: 'No groups defined yet...',
    OVERVIEW_GROUPS_SHARE: '* You can share group statistics in the "Statistics" page.',
    OVERVIEW_GROUPS_DELETE: '** Deleting the group will not delete the users in this group.',
    OVERVIEW_GROUPS_DELETEBTN: 'Delete group**',
    OVERVIEW_GROUPS_CREATE: 'Create group',
    OVERVIEW_GROUPS_CREATE_NAME: 'Group name',
    OVERVIEW_GROUPS_CREATEBTN: 'Create group',
    OVERVIEW_GROUPS_PLACEHOLDER: 'name of the group (required)',
    OVERVIEW_GROUPS_CLOSE: 'Close',
    OVERVIEW_PERFORMANCE_H: 'Manage User Interface Performance',
    OVERVIEW_PERFORMANCE_TIMELINE: 'Account timeline',
    OVERVIEW_PERFORMANCE_TIMELINE_OPTION: 'Display history:',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP: 'This setting has a',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP2: 'big',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP3: 'performance impact when you (re)load a users timeline. This affects the overview, compare and shared profile page.',
    OVERVIEW_PERFORMANCE_TRACKER_H: 'Tracker sessions',
    OVERVIEW_PERFORMANCE_TRACKER_OPTION: 'Display in timeline',
    OVERVIEW_PERFORMANCE_TRACKER_EXP: 'This setting has a',
    OVERVIEW_PERFORMANCE_TRACKER_EXP2: 'small',
    OVERVIEW_PERFORMANCE_TRACKER_EXP3: 'performance impact when you (re)load a users timeline. This affects both the overview and compare page.',
    OVERVIEW_PERFORMANCE_SAVE: 'Save settings',
    OVERVIEW_PERFORMANCE_CLOSE: 'Close',
    COMPARE_SELECT: 'Select candidate(s)',
    COMPARE_ADD_TO_COMPARE: 'Add user to comparison',
    COMPARE_ADD: 'Add',
    COMPARE_ADD_GROUP_COMPARE: 'Add group to comparison',
    COMPARE_ADD_NOTICE: 'Loading large groups may cause a temporary browser freeze due to the vast amount of information.',
    COMPARE_CURR_LIST: 'Current candidates in the comparison:',
    COMPARE_CURR_LIST_INFO: 'Candidate / Privacy settings',
    COMPARE_LASTSEEN: 'last seen :',
    COMPARE_STATUSMSG: 'status messages :',
    COMPARE_PROFPIC: 'profile pic :',
    COMPARE_REMOVE: 'Remove',
    COMPARE_LOADING: 'Loading account information ...',
    COMPARE_CONTACTS: 'contacts*',
    COMPARE_EVERYBODY: 'everyone',
    COMPARE_CONTACTS_NOTICE: 'This privacy setting may be contacts or nobody. This can\'t be detected.',
    STATS_TOKEN_INFO: 'You are not allowed to view this group because the token is or became invalid.',
    STATS_TOKEN_GROUP: 'Shared group profile:',
    STATS_TOKEN_GROUP_INFO: 'This is a shared statistics report of the group',
    STATS_TOKEN_GROUP_INFO2: 'created by the hoster of this WhatsSpy Public instance.',
    STATS_NO_INFO: 'Not enough information available ...',
    STATS_LOADING: 'Loading information ...',
    STATS_FILTER: 'Filter options',
    STATS_NOTES: 'Notes',
    STATS_INFO_VALIDITY: 'All information on this page does not update. You can refresh by clicking the gray timestamp in "status".',
    STATS_TOKEN_GEN: 'Generate',
    STATS_TOKEN_RESET: 'Reset',
    STATS_SHARE_INFO: 'Sharing this statistics group page URL\'s will only work if WhatsSpy Public is available from the internet. Click on the token to copy the link.',
    STATS_H: 'WhatsSpy Public Statistics',
    STATS_TRACKER_STATUS: 'Tracker status',
    STATS_SESSION: 'Tracker sessions',
    STATS_FIRST_SESSION: 'First tracker session (start of information flow)',
    STATS_DB_CONTENT: 'Database content',
    STATS_NUMBER_OF_ACC: 'Number of accounts',
    STATS_ACCOUNTS: 'accounts',
    STATS_STATUSES: 'statuses',
    STATS_PROFPIC: 'profile pictures',
    STATS_STSMSG: 'status messages',
    STATS_H_ONLINE: 'Online/offline statuses gathered',
    STATS_H_TOTALTIME: 'Total time spent on WhatsApp by all contacts',
    STATS_H_PROFPICSUM: 'Profile pictures gathered',
    STATS_H_STATUSMSGSUM: 'Status messages gathered',
    STATS_H_PRIVACY: 'Privacy awareness',
    STATS_PRIVACY_H: 'Privacy settings of tracked users',
    STATS_PRIVACY_TABLE_TH1: 'Privacy option',
    STATS_PRIVACY_TABLE_TH2: 'contacts/nobody',
    STATS_PRIVACY_TABLE_TH3: 'everyone',
    STATS_PRIVACY_OPTION1: 'Lastseen*',
    STATS_PRIVACY_OPTION2: 'Status messages',
    STATS_PRIVACY_OPTION3: 'Profile pictures',
    STATS_PRIVACY_USERS: 'users',
    STATS_PRIVACY_HISTORY: 'Privacy changes while tracking',
    STATS_PRIVACY_LASTSEEN: 'Lastseen privacy changes',
    STATS_PRIVACY_CHANGE: 'changes',
    STATS_PRIVACY_PROFPIC: 'Profile picture privacy changes',
    STATS_PRIVACY_STATUSMSG: 'Status message privacy changes',
    STATS_PRIVACY_INFO1: '* The lastseen option does not protect you against tracking online/offline statuses. Check this',
    STATS_PRIVACY_INFO2: 'article',
    STATS_PRIVACY_INFO3: 'explaining the problem in detail.',
    STATS_PIE_CHART_ONLINE_TIME_H: 'WhatsApp usage (online time / opening) compared per user',
    STATS_PIE_CHART_TODAY: 'Show today',
    STATS_PIE_CHART_7DAYS: 'Show 7 days',
    STATS_PIE_CHART_14DAYS: 'Show 14 days',
    STATS_PIE_CHART_ALL: 'Show all',
    STATS_PIE_CHART_PIE_OPEN_H_ALL: 'Opening WhatsApp - All',
    STATS_PIE_CHART_PIE_OPEN_H_7DAYS: 'Opening WhatsApp - Last 7 days',
    STATS_PIE_CHART_PIE_OPEN_H_14DAYS: 'Opening WhatsApp - Last 14 days',
    STATS_PIE_CHART_PIE_OPEN_H_TODAY: 'Opening WhatsApp - Today',
    STATS_PIE_CHART_PIE_ONLINE_H_ALL: 'Online time in WhatsApp - All',
    STATS_PIE_CHART_PIE_ONLINE_H_7DAYS: 'Online time in WhatsApp - Last 7 days',
    STATS_PIE_CHART_PIE_ONLINE_H_14DAYS: 'Online time in WhatsApp - Last 14 days',
    STATS_PIE_CHART_PIE_ONLINE_H_TODAY: 'Online time in WhatsApp - Today',
    STATS_PIE_CHART_PIE_INFO: 'Please note that every online session can be off by 0-4 seconds based on WhatsApp, your machine and your network activity. This means all this data is the maximum time they spent on WhatsApp.',
    STATS_PIE_CHART_BAR_H: 'WhatsApp usage (online time / opening) compared per timeunit',
    STATS_PIE_CHART_BAR_OPEN_H_WEEKDAY: 'Opening WhatsApp per weekday',
    STATS_PIE_CHART_BAR_OPEN_H_HOUR: 'Opening WhatsApp per hour',
    STATS_PIE_CHART_BAR_SHOWHOUR: 'Show per hour',
    STATS_PIE_CHART_BAR_SHOWWEEKDAY: 'Show per weekday',
    STATS_PIE_CHART_BAR_TIME_H_WEEKDAY: 'Time on WhatsApp per weekday',
    STATS_PIE_CHART_BAR_TIME_H_HOUR: 'Time on WhatsApp per hour',
    STATS_BAR_CHART_TODAY: 'today',
    STATS_BAR_CHART_7DAYS: '7 days',
    STATS_BAR_CHART_14DAYS: '14 days',
    STATS_BAR_CHART_ALLTIME: 'all time',
    STATS_TOP_H1: 'Top',
    STATS_TOP_H2: 'tracked users',
    STATS_TOP_ALL_SHOW: 'Show all',
    STATS_TOP_H3: 'most active users per day',
    STATS_TOP_DAYS_AGO: 'days ago',
    STATS_TOP_YESTERDAY: 'Yesterday',
    STATS_TOP_TODAY: 'Today',
    STATS_TOP_TRACKED_CONTACT: 'Tracked contact',
    STATS_TOP_TIME: 'Time online',
    STATS_TOP_OPENED: 'Opened WA',
    STATS_TOP_TIMES: 'times',
    STATS_TOP_H4: 'most active users in total',
    STATS_TOP_ALL: 'All',
    STATS_TOP_DAYS: 'days',
    STATS_TOP_HOURS: 'hours',
    STATS_TYPE_today: 'today',
    STATS_TYPE_yesterday: 'yesterday',
    STATS_TYPE_2days_ago: '2 days ago',
    STATS_TYPE_3days_ago: '3 days ago',
    STATS_TYPE_4days_ago: '4 days ago',
    STATS_TYPE_alltime: 'all time',
    STATS_TYPE_31days: '31 days',
    STATS_TYPE_14days: '14 days',
    STATS_TYPE_7days: '7 days',
    STATS_TYPE_24hours: '24 hours',
    TIMELINE_FILTER: 'Filters',
    TIMELINE_FILTER_PHONE_PLACEHOLDER: 'Search by phone number ...',
    TIMELINE_FILTER_NAME_PLACEHOLDER: 'Use name|name to filter on multiple names.',
    TIMELINE_SEARCH_NAME: 'Search by name ...',
    TIMELINE_INFO_STATUS: 'The system is checking all statuses',
    TIMELINE_INFO_FROM: 'from',
    TIMELINE_INFO_CONTACTS: 'contacts',
    TIMELINE_INFO_CONTINIOUS: 'continuously from',
    TIMELINE_INFO_LASTSTATUS: 'Contacts that have "last seen" set to "nobody" will be',
    TIMELINE_INFO_LASTSTATUS2: 'tracked anyway',
    TIMELINE_INFO_LIVE: 'Unlike the overview and comparison page, this information is live.',
    TIMELINE_FILTER_NOTIFY: 'Notify for any event (with filter)',
    TIMELINE_FILTER_TRACKER: 'Show tracker events',
    TIMELINE_ACTIVITY_H: 'Activity Timeline',
    TIMELINE_STATUS_H: 'Status Timeline',
    TIMELINE_ACTIVITY_TIMESPAN1: 'Activity timeline',
    TIMELINE_ACTIVITY_TIMESPAN2: 'from',
    TIMELINE_ACTIVITY_TIMESPAN3: 'till now',
    TIMELINE_ACTIVITY_TRACKERSTART: 'Tracker is now online',
    TIMELINE_ACTIVITY_TRACKERSTART_STARTED: 'started at',
    TIMELINE_ACTIVITY_TRACKERSTOP: 'Tracker is now offline',
    TIMELINE_ACTIVITY_TRACKERSTOP_SESSION: 'this session lasted from',
    TIMELINE_ACTIVITY_TRACKERSTOP_TILL: 'till',
    TIMELINE_ACTIVITY_TRACKERSTOP_REASON: 'Reason:',
    TIMELINE_ACTIVITY_TRACKERSTOP_SUPPORT: 'Support for common problems',
    TIMELINE_ACTIVITY_STATUSMSG: 'New status message for',
    TIMELINE_ACTIVITY_STATUSMSG_TO: 'changed to',
    TIMELINE_ACTIVITY_PROFPIC: 'New profile photo for',
    TIMELINE_ACTIVITY_PROFPIC_TITLE: 'Detecting profile picture changes can take 0-4 hours.',
    TIMELINE_ACTIVITY_PRIV: 'changed his privacy setting',
    TIMELINE_ACTIVITY_PRIV_OPTION: 'Privacy option',
    TIMELINE_ACTIVITY_PRIV_LASTSEEN: 'last seen',
    TIMELINE_ACTIVITY_PRIV_SETTO: 'is now set to',
    TIMELINE_ACTIVITY_PRIV_CONTACTS: 'contacts*',
    TIMELINE_ACTIVITY_PRIV_EVERYONE: 'everyone',
    TIMELINE_ACTIVITY_PRIV_CONTACTSTITLE: 'This privacy setting may be contacts or nobody. This can\'t be detected.',
    TIMELINE_ACTIVITY_PRIV_PROFPIC: 'profile picture',
    TIMELINE_ACTIVITY_PRIV_STATUSMSG: 'status messages',
    TIMELINE_ACTIVITY_NOINFO: 'No information available ..',
    TIMELINE_ACTIVITY_LOADMORE: 'Click to load 7 more days of older entries ..',
    TIMELINE_STATUS_ONLINE: 'Online from',
    TIMELINE_STATUS_TILL: 'till',
    TIMELINE_STATUS_NOINFO: 'No information available ..',
    TIMELINE_STATUS_NOINFOFILTER: 'No current user statuses for this filter ..',
    ABOUT_LICENSE0: 'WhatsSpy Public is a Proof of Concept to show how broken Whatsapp privacy settings are. With this tool you can basicly follow anyone\'s behaviour with only the knowledge of their phone number. This tool is for Proof of Concept purposes only! Please read the',
    ABOUT_LICENSE1: 'license',
    ABOUT_LICENSE2: 'which applies to this PoC.',
    ABOUT_DONATION0: 'You can support this work by a small donation:',
    ABOUT_DONATION1: 'Bitcoin:',
    ABOUT_DONATION2: 'or via',
    ABOUT_DONATION3: 'Paypal',
    ABOUT_INFO: 'General information',
    ABOUT_VERSION: 'Running version:',
    ABOUT_UPDATE: 'is available.',
    ABOUT_UPTODATE: 'Your version is up to date.',
    ABOUT_UPDATE_NOW: 'Update',
    ABOUT_UPDATE_LOG: 'Updatelog and how-to-update',
    ABOUT_WIKI: 'Wiki home page:',
    ABOUT_WIKI_LINK: 'Gitlab Wiki',
    ABOUT_FAQ: 'FAQ:',
    ABOUT_FAQ_LINK: 'Frequently Asked Questions',
    ABOUT_TROUBLE: 'Troubleshooting:',
    ABOUT_TROUBLE_LINK: 'Troubleshooting',
    ABOUT_OPTIONS: 'Options:',
    ABOUT_OPTIONS_LOGOUT: 'Logout WebUI',
    ABOUT_LANGUAGE: 'Client Language:',
    ABOUT_ADVANCED: 'Advanced options:',
    ABOUT_ADVANCED_STOP: 'Stop tracker',
    ABOUT_ADVANCED_START: 'Start tracker',
    ABOUT_ADVANCED_UPDATE: 'Auto update',
    ABOUT_NEWS: 'Literature/news for this project:',
    ABOUT_AGENTS: 'Notification agents',
    ABOUT_AGENTS_NONE1: 'There are no notification agents configured in',
    ABOUT_AGENTS_NONE2: 'config.php',
    ABOUT_AGENTS_NONE3: 'Check config.example.php in case you are missing these options.',
    ABOUT_AGENTS_PROPS: 'Notifying properties:',
    ABOUT_AGENTS_USER: 'user actions',
    ABOUT_AGENTS_TRACKER: 'tracker actions',
    ABOUT_AGENTS_TO: 'to:',
    ABOUT_AGENTS_RESTART: 'Remember to restart the tracker after any change in your config.php.',
    ABOUT_QA: 'Question and Answers',
    CONTROLLER_TIMELINE_1D: '24 hours (best performance)',
    CONTROLLER_TIMELINE_7D: '7  days',
    CONTROLLER_TIMELINE_14D: '14 days',
    CONTROLLER_TIMELINE_31D: '31 days (slow)',
    CONTROLLER_TIMELINE_90D: '90 days (very slow)',
    CONTROLLER_CHAR_OPENED: 'opened',
    CONTROLLER_CHAR_TIMES: 'times',
    CONTROLLER_CHAR_MINUTES: 'minutes',
    CONTROLLER_COPY: 'Copy to clipboard: Ctrl+C, Enter',
    CONTROLLER_WEEKDAY_Sunday: 'Sunday',
    CONTROLLER_WEEKDAY_Monday: 'Monday',
    CONTROLLER_WEEKDAY_Tuesday: 'Tuesday',
    CONTROLLER_WEEKDAY_Wednesday: 'Wednesday',
    CONTROLLER_WEEKDAY_Thursday: 'Thursday',
    CONTROLLER_WEEKDAY_Friday: 'Friday',
    CONTROLLER_WEEKDAY_Saturday: 'Saturday',
    CONTROLLER_NONAME: 'No name',
    CONTROLLER_NOTOKEN: 'Not shared ...',
    CONTROLLER_TRACKER_REASON_NONE: 'not given',
    CONTROLLER_TIME_DAY: 'd',
    CONTROLLER_TIME_HOURS: 'h',
    CONTROLLER_TIME_MINUTES: 'min',
    CONTROLLER_TIME_SECONDS: 'sec',
    CONTROLLER_SERVER_NO_RES: 'Could not contact the server.',
    CONTROLLER_GROUP_NEW: 'Enter the new name for this group:',
    CONTROLLER_ACCOUNT_DEL: 'Are you sure you want to delete this Account?',
    CONTROLLER_ACCOUNT_REMOVED: ' removed!',
    CONTROLLER_ACCOUNT_UPDATED: 'Contact updated',
    CONTROLLER_ACCOUNT_ADDED: 'Contact added to WhatsSpy. Tracking will start in 5-10 minutes.',
    CONTROLLER_ACCOUNT_INACTIVE: ' set inactive!',
    CONTROLLER_GROUP_SAVE: 'Saved new groupname!',
    CONTROLLER_GROUP_ADD: 'New group added.',
    CONTROLLER_GROUP_DEL: 'Group removed.',
    CONTROLLER_CONFIG_UPDATE: 'Configuration updated',
    CONTROLLER_TIME_DAY_FULL: 'day',
    CONTROLLER_TIME_WEEK_FULL: 'week',
    CONTROLLER_TIME_MONTH_FULL: 'month',
    CONTROLLER_TIME_CUSTOM_FULL: 'custom',
    CONTROLLER_TIMELINE_HISTORY: 'History view:',
    CONTROLLER_TIMELINE_DAYS: 'day(s)',
    CONTROLLER_TIMELINE_ONLINE: 'Online',
    CONTROLLER_TIMELINE_DURATION: 'Duration:',
    CONTROLLER_COMPARISON_ALREADY_IN: ' is already in the comparison!',
    CONTROLLER_NOTIFICATION_ONLINE: ' is now online.',
    CONTROLLER_NOTIFICATION_STATUSMSG: ' has a new status message: ',
    CONTROLLER_NOTIFICATION_PROFPIC: ' has a new profile picture.',
    CONTROLLER_NOTIFICATION_PIRV_EVERY: 'everybody',
    CONTROLLER_NOTIFICATION_PRIV_CONTACTS: 'contacts or nobody',
    CONTROLLER_NOTIFICATION_PRIV_LASTSEEN: ' has changed his last seen privacy setting to ',
    CONTROLLER_NOTIFICATION_PRIV_PROFPIC: ' has changed his profile picture privacy setting to ',
    CONTROLLER_NOTIFICATION_PRIV_STATUSMSG: ' has changed his status message privacy setting to ',
    CONTROLLER_NOTIFICATION_TRACKER_START: 'Tracker has started tracking.',
    CONTROLLER_NOTIFICATION_TRACKER_STOP: 'Tracker has stopped tracking with reason: ',
    CONTROLLER_STAT_TIMES: 'times',
    CONTROLLER_CMD0: 'CMD: ',
    CONTROLLER_CMD1: ' resulted in code: ',
    CONTROLLER_CMD2: ' with output: ',
    PRIVACY_STATUS_EVERYONE: 'everyone',
    PRIVACY_STATUS_CONTACTS_OR_NOBODY: 'contacts or nobody'
    });
    moment.locale('en', {
        months : [
            "January", "February", "March", "April", "May", "June", "July",
            "August", "September", "October", "November", "December"
        ],
        monthsShort : [
            "Jan", "Feb", "Mar", "Apr", "May", "Jun",
            "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
        ],
        weekdays : [
            "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"
        ],
        weekdaysShort : [
            "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
        ],
        longDateFormat : {
            LT: "h:mm A",
            LTS: "h:mm:ss A",
            L: "MM/DD/YYYY",
            l: "M/D/YYYY",
            LL: "MMMM Do YYYY",
            ll: "MMM D YYYY",
            LLL: "MMMM Do YYYY LT",
            lll: "MMM D YYYY LT",
            LLLL: "dddd, MMMM Do YYYY LT",
            llll: "ddd, MMM D YYYY LT"
        },
        relativeTime : {
            future: "in %s",
            past:   "%s ago",
            s:  "seconds",
            m:  "a minute",
            mm: "%d minutes",
            h:  "an hour",
            hh: "%d hours",
            d:  "a day",
            dd: "%d days",
            M:  "a month",
            MM: "%d months",
            y:  "a year",
            yy: "%d years"
        }
    });

    $translateProvider.translations('nl', {
    /* PLEASE NOTE that spaces etc. are all of importance here. You also must escape ' (by using \') */
    /* Use your gitlab/real name here to identify your work */
    TRANSLATOR: '',
    MENU_LOGIN: 'Login',
    MENU_OVERVIEW: 'Overzicht',
    MENU_COMPARE: 'Vergelijken',
    MENU_TIMELINE: 'Tijdlijn',
    MENU_STATS: 'Statistieken',
    MENU_ABOUT: 'Over / Help',
    MENU_USER: 'Publieke gebruiker',
    MENU_GROUP: 'Publieke groep',
    MENU_LOADING: 'Nieuwe informatie aan het laden ...',
    MENU_STATUS: 'status',
    MENU_TRACKER_ONLINE: 'Tracker online',
    MENU_TRACKER_OFFLINE: 'Tracker offline',
    MENU_TRACKER_NOAUTH: 'niet geauthenticeerd',
    MENU_TRACKER_USERS: 'gebruikers',
    MENU_TRACKER_REFRESH: 'Klik hierop om de informatie binnen de web applicatie te verversen.',
    MENU_POC: 'Proof of Concept',
    FOOTER_VERSION: 'Versie',
    FOOTER_V_BEHIND: 'Loopt achter',
    LOGIN_WELCOME: 'Welkom!',
    LOGIN_WELCOME_MSG: 'Welkom bij het WhatsSpy Public PoC! Voordat je begint, lees aub de ',
    LOGIN_LICENSE: 'overeenkomst',
    LOGIN_LOGIN_HEAD: 'Login',
    LOGIN_AUTH_NOTIFY: 'Het ziet er naar uit dat je nog niet bent ingelogd. Authenticeer jezelf eerst voordat je begint.',
    LOGIN_PASS_FIELD: 'Wachtwoord',
    LOGIN_SIGN_IN_BTN: 'Login',
    LOGIN_RESET_BTN: 'Reset',
    LOGIN_PASS_PLACEHOLDER: 'wachtwoord ...',
    TOKEN_INVALID: 'Ongeldige token:',
    OVERVIEW_TOKEN_INVALID: 'Je hebt geen toegang (meer) tot deze pagina.',
    OVERVIEW_TOKEN_INFO_STRONG: 'Gedeelde gebruikers profiel:',
    OVERVIEW_TOKEN_INFO: 'Dit is een gedeeld profiel aangemaakt door de beheerder van deze WhatsSpy Public instantie. De tijdlijn bevat slechts een samenvatting van alle statussen.',
    OVERVIEW_FILTERS: 'Filters',
    OVERVIEW_FILTER_PHONE: 'Zoek met telefoonnummer ...',
    OVERVIEW_FILTER_NAME_TITLE: 'Gebruik naam|naam om te filteren op meerdere namen.',
    OVERVIEW_FILTER_NAME: 'Zoek met een naam ...',
    OVERVIEW_INFO_STATUS: 'Het systeem controleert alle statussen',
    OVERVIEW_INFO_STATUS_FROM: 'van',
    OVERVIEW_INFO_STATUS_CONTACTS: 'contacten',
    OVERVIEW_INFO_STATUS_SINCE: 'vanaf',
    OVERVIEW_INFO_PRIV: 'WhatsApp gebruikers die hun laatst gezien op "niemand" hebben staan ',
    OVERVIEW_INFO_PRIV_LINK: 'worden alsnog gevolgd',
    OVERVIEW_INFO_LIVE: 'De informatie binnen deze pagina is niet live. Je kan de informatie herladen door op de tijd in het "status" scherm te drukken.',
    OVERVIEW_INFO_TIMESPAN: 'Je ziet alle informatie vanaf het moment dat je deze gebruiker volgt.',
    OVERVIEW_INFO_VERIFY: 'nieuwe contacten zullen worden gecontroleerd binnen 5-10 minuten,',
    OVERVIEW_INFO_RELOAD: 'herlaad informatie',
    OVERVIEW_INFO_RELOAD_2: 'om te zien of dit is voltooid.',
    OVERVIEW_ADD: 'Nieuw contact',
    OVERVIEW_IMPORT: 'Importeer Google Contacts',
    OVERVIEW_MANAGE_GROUPS: 'Beheer groepen',
    OVERVIEW_MANAGE_PERF: 'Prestatie opties',
    OVERVIEW_EXPAND: 'Meer',
    OVERVIEW_COLLAPSE: 'Minder',
    OVERVIEW_EDIT: 'Bewerk',
    OVERVIEW_CONTACT_SINCE: 'gevolgd sinds',
    OVERVIEW_CONTACT_LASTSEEN: 'laatst gezien',
    OVERVIEW_CONTACT_NOTIF: 'meldingen aan',
    OVERVIEW_CONTACT_SHARING: 'profiel delen aan',
    OVERVIEW_NO_INFO: 'Geen informatie beschikbaar ..',
    OVERVIEW_CLICK_LOAD: 'Klik om informatie te laden',
    OVERVIEW_CLICK_LOAD_TIMELINE: 'Laad tijdlijn',
    OVERVIEW_CONTACT_H_ANALYTICS: 'Analyse / Informatie',
    OVERVIEW_CONTACT_ANALYTICS_OVERVIEW: 'Overzicht',
    OVERVIEW_CONTACT_ANALYTICS_OPENOVERVIEW: 'Geopend overzicht',
    OVERVIEW_CONTACT_ANALYTICS_TIME_OVERVIEW: 'Tijd overzicht',
    OVERVIEW_CONTACT_ANALYTICS_STATUS: 'Status berichten',
    OVERVIEW_CONTACT_ANALYTICS_PICS: 'Profiel afbeeldingen',
    OVERVIEW_CONTACT_OPENED_H: 'WhatsApp client geopend',
    OVERVIEW_CONTACT_TABLE_1D: '(24h) vandaag',
    OVERVIEW_CONTACT_TABLE_7D: '(07d) laatste 7 dagen',
    OVERVIEW_CONTACT_TABLE_14D: '(14d) laatste 2 weken',
    OVERVIEW_CONTACT_TABLE_31D: '(31d) laatste maand',
    OVERVIEW_CONTACT_TABLE_xD: '(---) alles',
    OVERVIEW_CONTACT_TRACKING_SINCE: 'Gevolgd sinds',
    OVERVIEW_CONTACT_TIME_SPENT_WA: 'Tijd gespendeerd op WhatsApp',
    OVERVIEW_CONTACT_LOADING_INFO: 'Informatie laden ...',
    OVERVIEW_CONTACT_SWITCH_HOUR_VIEW: 'Toon per uur',
    OVERVIEW_CONTACT_SWITCH_WEEKDAY_VIEW: 'Toon per weekdag',
    OVERVIEW_CONTACT_H_OPENING_WA_WEEKDAY: 'WhatsApp openen per weekdag',
    OVERVIEW_CONTACT_H_OPENING_WA_HOUR: 'WhatsApp openen per uur',
    OVERVIEW_CONTACT_H_TIME_WA_WEEKDAY: 'Tijd op WhatsApp per weekdag',
    OVERVIEW_CONTACT_H_TIME_WA_HOUR: 'Tijd op WhatsApp per uur',
    OVERVIEW_CONTACT_H_PRIV_STATUS: 'Privacy / Online status',
    OVERVIEW_CONTACT_PRIV_STATUS: 'Privacy',
    OVERVIEW_CONTACT_ONLINE_EVENTS: 'Online gebeurtenissen',
    OVERVIEW_CONTACT_H_LASTSEEN: 'Laatst gezien',
    OVERVIEW_CONTACT_TIMES: 'keer',
    OVERVIEW_PRIVACY_SETTINGS_PUBLIC: 'iedereen',
    OVERVIEW_PRIVACY_SETTINGS_FRIENDS: 'contacten*',
    OVERVIEW_PRIVACY_LAST_CHANGE: 'veranderd naar',
    OVERVIEW_PRIVACY_LAST_CHANGE_AT: 'om',
    OVERVIEW_PRIVACY_H_PROF_PIC: 'Profielfoto',
    OVERVIEW_PRIVACY_H_STATUS: 'Status berichten',
    OVERVIEW_PRIVACY_TRACK_NOTICE: 'Profiel fotos en status berichten worden elke 2 uur gecontroleerd.',
    OVERVIEW_PRIVACY_ASSUMPTION: 'Er vanuitgaand dat de gebruiker jouw telefoonnummer niet in zijn contactenlijst heeft staan. Is dit wel het geval, dan is \'alleen contacten\' eigenlijk \'iedereen\' in dit overzicht.',
    OVERVIEW_LOG_FROM: 'vanaf',
    OVERVIEW_LOG_TILL: 'tot',
    OVERVIEW_LOG_NOW: 'nu',
    OVERVIEW_NO_ACC: 'Geen accounts om te volgen ..',
    OVERVIEW_ADD_CONTACT_H: 'Voeg contact toe met telefoonnummer',
    OVERVIEW_ADD_CONTACT_PHONE: 'telefoonnummer',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_COUNTRYCODE: 'landcode ...',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_PHONE: 'telefoonnummer ...',
    OVERVIEW_ADD_CONTACT_NAME: 'Contact naam',
    OVERVIEW_ADD_CONTACT_GROUP: 'Groepen',
    OVERVIEW_ADD_CONTACT_NOTICE: 'Er wordt eerst gecontroleerd of dit telefoonnummer gebruik maakt van WhatsApp, dit kan 5 tot 10 minuten duren.',
    OVERVIEW_ADD_CONTACT_ADD: 'Voeg contact toe',
    OVERVIEW_ADD_CONTACT_CLOSE: 'Sluiten',
    OVERVIEW_EDIT_CONTACT_H: 'Bewerk contact naam',
    OVERVIEW_EDIT_CONTACT_PHONE: 'telefoonnummer',
    OVERVIEW_EDIT_CONTACT_NAME: 'Contact naam',
    OVERVIEW_EDIT_CONTACT_NAME_PLACEHOLDER: '(optioneel) naam van contact',
    OVERVIEW_EDIT_CONTACT_GROUPS: 'Groepen',
    OVERVIEW_EDIT_CONTACT_PROFILESHARE: 'Deel dit profiel',
    OVERVIEW_EDIT_CONTACT_GENERATE_TOKEN: 'Genereer',
    OVERVIEW_EDIT_CONTACT_RESET_TOKEN: 'Reset',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO: 'Het delen van profielen werkt alleen als deze installatie beschikbaar is vanaf het internet.',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO2: 'Klik op de token om de link te kopieeren.',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS: 'Notificaties',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_ONLINE: 'Online komen',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_STATUSMSG: 'Status bericht verandering',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PROFPIC: 'Profiel foto verandering',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PRIV: 'Privacy instellingen verandering',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS: 'Er zijn geen notificatie agents ingesteld in',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS_CONFIG: 'config.php',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_MISSING: 'Controleer config.example.php als deze opties niet in je config.php staan.',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_SENDING: 'Notificaties worden verstuurd via',
    OVERVIEW_AND: 'en',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE: 'Toon tijdlijn notificatie (als tijdlijn open is)',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE_EXPL: 'Notificatie geluid wat wordt gebruikt als deze gebruiker online komt.',
    OVERVIEW_EDIT_CONTACT_SAVE: 'Sla contact op',
    OVERVIEW_EDIT_CONTACT_INACTIVE: 'Zet op inactief',
    OVERVIEW_EDIT_CONTACT_DELETE: 'Verwijder contact (!)',
    OVERVIEW_EDIT_CONTACT_DETELE_TITLE: 'Verwijder alle informatie, inclusief status geschiedenis.',
    OVERVIEW_EDIT_CONTACT_INACTIVE_TITLE: 'Volg de contact niet langer, maar houd alle opgeslagen informatie vast in de database.',
    OVERVIEW_GROUPS_H: 'Beheer groepen',
    OVERVIEW_GROUPS_EXISTING: 'Bestaande groepen',
    OVERVIEW_GROUPS_USERS: 'Gebruikers:',
    OVERVIEW_GROUPS_STATSEN: 'Statistieken delen staat aan',
    OVERVIEW_GROUPS_STATSDIS: 'Delen staat uit*',
    OVERVIEW_GROUPS_NONE: 'Er bestaan nog geen groepen ...',
    OVERVIEW_GROUPS_SHARE: '* Je kan informatie over groepen delen via de "Statistieken" pagina.',
    OVERVIEW_GROUPS_DELETE: '** Het verwijderen van een groep zorgt niet voor het verwijderen van de gebruikers in die groep.',
    OVERVIEW_GROUPS_DELETEBTN: 'Verwijder groep**',
    OVERVIEW_GROUPS_CREATE: 'Creëer groep',
    OVERVIEW_GROUPS_CREATE_NAME: 'Groep naam',
    OVERVIEW_GROUPS_CREATEBTN: 'Creëer groep',
    OVERVIEW_GROUPS_PLACEHOLDER: 'naam van de groep (verplicht)',
    OVERVIEW_GROUPS_CLOSE: 'Sluiten',
    OVERVIEW_PERFORMANCE_H: 'Beheer User Interface prestaties',
    OVERVIEW_PERFORMANCE_TIMELINE: 'Account tijdlijn',
    OVERVIEW_PERFORMANCE_TIMELINE_OPTION: 'Geschiedenis:',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP: 'Deze instelling heeft een',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP2: 'grote',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP3: 'impact wanneer je een tijdlijn (her)laad (in overview en compare pagina).',
    OVERVIEW_PERFORMANCE_TRACKER_H: 'Tracker sessies',
    OVERVIEW_PERFORMANCE_TRACKER_OPTION: 'Toon in de tijdlijn',
    OVERVIEW_PERFORMANCE_TRACKER_EXP: 'Deze instelling heeft een',
    OVERVIEW_PERFORMANCE_TRACKER_EXP2: 'kleine',
    OVERVIEW_PERFORMANCE_TRACKER_EXP3: 'impact wanneer je een tijdlijn (her)laad (in overview en compare pagina).',
    OVERVIEW_PERFORMANCE_SAVE: 'Instellingen opslaan',
    OVERVIEW_PERFORMANCE_CLOSE: 'Sluiten',
    COMPARE_SELECT: 'Selecteer kandidaten',
    COMPARE_ADD_TO_COMPARE: 'Voeg gebruiker toe aan vergelijking',
    COMPARE_ADD: 'Voeg toe',
    COMPARE_ADD_GROUP_COMPARE: 'Voeg groep toe aan vergelijking',
    COMPARE_ADD_NOTICE: 'Het laden van grote groepen kan tijdelijk lijden tot een browser freeze.',
    COMPARE_CURR_LIST: 'Huidige kandidaten in de vergelijking:',
    COMPARE_CURR_LIST_INFO: 'kandidaat / Privacy instellingen',
    COMPARE_LASTSEEN: 'laatst gezien :',
    COMPARE_STATUSMSG: 'status berichten :',
    COMPARE_PROFPIC: 'profiel foto :',
    COMPARE_REMOVE: 'Verwijder',
    COMPARE_LOADING: 'Informatie aan het laden ...',
    COMPARE_CONTACTS: 'contacten*',
    COMPARE_EVERYBODY: 'iedereen',
    COMPARE_CONTACTS_NOTICE: 'Deze privacy instelling zowel opgevat worden als contacten of niemand, dit kan niet bepaald worden.',
    STATS_TOKEN_INFO: 'Je mag deze groep/gebruiker niet meer inzien omdat de token ongeldig is.',
    STATS_TOKEN_GROUP: 'Gedeelde groep informatie:',
    STATS_TOKEN_GROUP_INFO: 'Dit is een gedeeld rapport over de groep',
    STATS_TOKEN_GROUP_INFO2: 'gecreëerd door de eigenaar van deze WhatsSpy Public instantie.',
    STATS_NO_INFO: 'Niet genoeg informatie beschikbaar ...',
    STATS_LOADING: 'Informatie aan het laden ...',
    STATS_FILTER: 'Filter opties',
    STATS_NOTES: 'Opmerking',
    STATS_INFO_VALIDITY: 'Alle informatie in deze pagina update niet automatisch. Om de informatie te herladen kan je op de tijd klikken in het status paneel.',
    STATS_TOKEN_GEN: 'Genereer',
    STATS_TOKEN_RESET: 'Reset',
    STATS_SHARE_INFO: 'Het delen van een groep werkt alleen als deze installatie vanaf het internet te benaderen is.',
    STATS_H: 'WhatsSpy Public Statestieken',
    STATS_TRACKER_STATUS: 'Tracker status',
    STATS_SESSION: 'Tracker sessies',
    STATS_FIRST_SESSION: 'Eerste tracker sessie (begin van informatie verzameling)',
    STATS_DB_CONTENT: 'Database content',
    STATS_NUMBER_OF_ACC: 'Aantal accounts',
    STATS_ACCOUNTS: 'accounts',
    STATS_STATUSES: 'statussen',
    STATS_PROFPIC: 'profiel fotos',
    STATS_STSMSG: 'status berichten',
    STATS_H_ONLINE: 'Online/offline statussen verzameld',
    STATS_H_TOTALTIME: 'Totale tijd gespendeerd op WhatsApp door alle contacten',
    STATS_H_PROFPICSUM: 'Profielfotos verzameld',
    STATS_H_STATUSMSGSUM: 'Status berichten verzameld',
    STATS_H_PRIVACY: 'Privacy bewustzijn',
    STATS_PRIVACY_H: 'Privacy settings van gevolgde contacten',
    STATS_PRIVACY_TABLE_TH1: 'Privacy optie',
    STATS_PRIVACY_TABLE_TH2: 'contacten/niemand',
    STATS_PRIVACY_TABLE_TH3: 'iedereen',
    STATS_PRIVACY_OPTION1: 'Laatst gezien*',
    STATS_PRIVACY_OPTION2: 'Status berichten',
    STATS_PRIVACY_OPTION3: 'Profiel fotos',
    STATS_PRIVACY_USERS: 'gebruikers',
    STATS_PRIVACY_HISTORY: 'Privacy veranderingen gedurend het tracken',
    STATS_PRIVACY_LASTSEEN: 'Laast gezien privacy veranderingen',
    STATS_PRIVACY_CHANGE: 'veranderingen',
    STATS_PRIVACY_PROFPIC: 'Profiel foto privacy veranderingen',
    STATS_PRIVACY_STATUSMSG: 'Status berichten privacy veranderingen',
    STATS_PRIVACY_INFO1: '* Het laastgezien privacy optie binnen WhatsApp beschermt je niet tegen het volgen. ',
    STATS_PRIVACY_INFO2: 'Lees meer',
    STATS_PRIVACY_INFO3: 'over het probleem in detail.',
    STATS_PIE_CHART_ONLINE_TIME_H: 'WhatsApp gebruik (online tijd / openen) vergeleken per account',
    STATS_PIE_CHART_TODAY: 'Toon vandaag',
    STATS_PIE_CHART_7DAYS: 'Toon 7 dagen',
    STATS_PIE_CHART_14DAYS: 'Toon 14 dagen',
    STATS_PIE_CHART_ALL: 'Toon alles',
    STATS_PIE_CHART_PIE_OPEN_H_ALL: 'WhatsApp Openen - Alles',
    STATS_PIE_CHART_PIE_OPEN_H_7DAYS: 'WhatsApp Openen - Laatste 7 dagen',
    STATS_PIE_CHART_PIE_OPEN_H_14DAYS: 'WhatsApp Openen - Laatste 14 dagen',
    STATS_PIE_CHART_PIE_OPEN_H_TODAY: 'WhatsApp Openen - Vandaag',
    STATS_PIE_CHART_PIE_ONLINE_H_ALL: 'Online time in WhatsApp - Alles',
    STATS_PIE_CHART_PIE_ONLINE_H_7DAYS: 'Online time in WhatsApp - Laatste 7 dagen',
    STATS_PIE_CHART_PIE_ONLINE_H_14DAYS: 'Online time in WhatsApp - Laatste 14 dagen',
    STATS_PIE_CHART_PIE_ONLINE_H_TODAY: 'Online time in WhatsApp - Vandaag',
    STATS_PIE_CHART_PIE_INFO: 'Let op dat elke WhatsApp sessie kan afwijken met maximaal 4 seconden. Dit betekent dat deze informatie gezien wordt als de maximale tijd die iemand op WhatsApp zit.',
    STATS_PIE_CHART_BAR_H: 'WhatsApp gebruikt (online tijd / openen) vergeleken per tijdseenheid',
    STATS_PIE_CHART_BAR_OPEN_H_WEEKDAY: 'WhatsApp Openen per weekdag',
    STATS_PIE_CHART_BAR_OPEN_H_HOUR: 'WhatsApp Openen per uur',
    STATS_PIE_CHART_BAR_SHOWHOUR: 'Toon per uur',
    STATS_PIE_CHART_BAR_SHOWWEEKDAY: 'Toon per weekdag',
    STATS_PIE_CHART_BAR_TIME_H_WEEKDAY: 'Tijd op WhatsApp per weekdag',
    STATS_PIE_CHART_BAR_TIME_H_HOUR: 'Tijd op WhatsApp per uur',
    STATS_BAR_CHART_TODAY: 'vandaag',
    STATS_BAR_CHART_7DAYS: '7 dagen',
    STATS_BAR_CHART_14DAYS: '14 dagen',
    STATS_BAR_CHART_ALLTIME: 'alles',
    STATS_TOP_H1: 'Top',
    STATS_TOP_H2: 'gevolgde contacten',
    STATS_TOP_ALL_SHOW: 'Toon alles',
    STATS_TOP_H3: 'meest actieve contacten per dag',
    STATS_TOP_DAYS_AGO: 'dagen geleden',
    STATS_TOP_YESTERDAY: 'Gisteren',
    STATS_TOP_TODAY: 'Vandaag',
    STATS_TOP_TRACKED_CONTACT: 'Gevolgde contact',
    STATS_TOP_TIME: 'Tijd online',
    STATS_TOP_OPENED: 'WhatsApp geopend',
    STATS_TOP_TIMES: 'keer',
    STATS_TOP_H4: 'meest actieve contacten in totaal',
    STATS_TOP_ALL: 'Alles',
    STATS_TOP_DAYS: 'dagen',
    STATS_TOP_HOURS: 'uren',
    STATS_TYPE_today: 'vandaag',
    STATS_TYPE_yesterday: 'gisteren',
    STATS_TYPE_2days_ago: '2 dagen geleden',
    STATS_TYPE_3days_ago: '3 dagen geleden',
    STATS_TYPE_4days_ago: '4 dagen gelden',
    STATS_TYPE_alltime: 'alles',
    STATS_TYPE_31days: '31 dagen',
    STATS_TYPE_14days: '14 dagen',
    STATS_TYPE_7days: '7 dagen',
    STATS_TYPE_24hours: '24 uur',
    TIMELINE_FILTER: 'Filters',
    TIMELINE_FILTER_PHONE_PLACEHOLDER: 'Zoek op telefoonnummer ...',
    TIMELINE_FILTER_NAME_PLACEHOLDER: 'Gebruik naam|naam om op meerdere contacten te zoeken.',
    TIMELINE_SEARCH_NAME: 'Zoek op naam ...',
    TIMELINE_INFO_STATUS: 'Het systeem controleert alle statussen van',
    TIMELINE_INFO_FROM: 'van',
    TIMELINE_INFO_CONTACTS: 'contacten',
    TIMELINE_INFO_CONTINIOUS: 'vanaf',
    TIMELINE_INFO_LASTSTATUS: 'WhatsApp gebruikers die hun laatst gezien op "niemand" hebben staan ',
    TIMELINE_INFO_LASTSTATUS2: 'worden alsnog gevolgd',
    TIMELINE_INFO_LIVE: 'In tegenstelling tot de overzicht en vergelijking pagina is deze informatie live.',
    TIMELINE_FILTER_NOTIFY: 'Geef een notificatie voor elk event (met filter)',
    TIMELINE_FILTER_TRACKER: 'Toon tracker gebeurtenissen',
    TIMELINE_ACTIVITY_H: 'Activiteiten Tijdlijn',
    TIMELINE_STATUS_H: 'Status Tijdlijn',
    TIMELINE_ACTIVITY_TIMESPAN1: 'Activiteiten Tijdlijn',
    TIMELINE_ACTIVITY_TIMESPAN2: 'vanaf',
    TIMELINE_ACTIVITY_TIMESPAN3: 'tot nu',
    TIMELINE_ACTIVITY_TRACKERSTART: 'Tracker is nu online',
    TIMELINE_ACTIVITY_TRACKERSTART_STARTED: 'gestart op',
    TIMELINE_ACTIVITY_TRACKERSTOP: 'Tracker is nu offline',
    TIMELINE_ACTIVITY_TRACKERSTOP_SESSION: 'deze sessie liep van',
    TIMELINE_ACTIVITY_TRACKERSTOP_TILL: 'tot',
    TIMELINE_ACTIVITY_TRACKERSTOP_REASON: 'Reden:',
    TIMELINE_ACTIVITY_TRACKERSTOP_SUPPORT: 'Ondersteuning voor veel voorkomende problemen',
    TIMELINE_ACTIVITY_STATUSMSG: 'Nieuw status bericht voor',
    TIMELINE_ACTIVITY_STATUSMSG_TO: 'veranderd naar',
    TIMELINE_ACTIVITY_PROFPIC: 'Nieuwe profielfoto voor',
    TIMELINE_ACTIVITY_PROFPIC_TITLE: 'Het detecteren van een nieuwe profiel foto kan 0 tot 4 uur duren.',
    TIMELINE_ACTIVITY_PRIV: 'veranderd de privacy instelling',
    TIMELINE_ACTIVITY_PRIV_OPTION: 'Privacy optie',
    TIMELINE_ACTIVITY_PRIV_LASTSEEN: 'last seen',
    TIMELINE_ACTIVITY_PRIV_SETTO: 'is nu ingesteld op',
    TIMELINE_ACTIVITY_PRIV_CONTACTS: 'contacten*',
    TIMELINE_ACTIVITY_PRIV_EVERYONE: 'iedereen',
    TIMELINE_ACTIVITY_PRIV_CONTACTSTITLE: 'Deze privacy instelling kan zowel op contacten of niemand staan, dit kan niet gedetecteerd worden.',
    TIMELINE_ACTIVITY_PRIV_PROFPIC: 'profiel foto',
    TIMELINE_ACTIVITY_PRIV_STATUSMSG: 'status bericht',
    TIMELINE_ACTIVITY_NOINFO: 'Geen informatie beschikbaar ..',
    TIMELINE_ACTIVITY_LOADMORE: 'Klik hier om 7 dagen meer aan geschiedenis op te halen ..',
    TIMELINE_STATUS_ONLINE: 'Online vanaf',
    TIMELINE_STATUS_TILL: 'tot',
    TIMELINE_STATUS_NOINFO: 'Geen informatie beschikbaar ..',
    TIMELINE_STATUS_NOINFOFILTER: 'Geen contact statusses voor deze filter beschikbaar ..',
    ABOUT_LICENSE0: 'WhatsSpy Public is een Proof of Concept om aan te tonen hoe slecht het er voor staat met de privacy binnen WhatsApp. Met deze tool kan je het gedrag van iedereen op WhatsApp volgen met alleen de kennis over hun telefoonnummer. Deze tool is alleen voor Proof of Concept doeleinden! Lees asjeblieft de ',
    ABOUT_LICENSE1: 'overeenkomst',
    ABOUT_LICENSE2: 'die van toepassing is op dit PoC.',
    ABOUT_DONATION0: 'Je kan dit werk ondersteunen met een kleine donatie:',
    ABOUT_DONATION1: 'Bitcoin:',
    ABOUT_DONATION2: 'of via',
    ABOUT_DONATION3: 'Paypal',
    ABOUT_INFO: 'Algemene informatie',
    ABOUT_VERSION: 'Draaiende versie:',
    ABOUT_UPDATE: 'is beschikbaar.',
    ABOUT_UPTODATE: 'Jouw versie is up to date.',
    ABOUT_UPDATE_NOW: 'Update',
    ABOUT_UPDATE_LOG: 'Updatelog en hoe moet je updaten',
    ABOUT_WIKI: 'Wiki home page:',
    ABOUT_WIKI_LINK: 'Gitlab Wiki',
    ABOUT_FAQ: 'FAQ:',
    ABOUT_FAQ_LINK: 'Frequently Asked Questions',
    ABOUT_TROUBLE: 'Ondersteuning:',
    ABOUT_TROUBLE_LINK: 'Ondersteuning',
    ABOUT_OPTIONS: 'Opties:',
    ABOUT_OPTIONS_LOGOUT: 'Logout WebUI',
    ABOUT_LANGUAGE: 'Taal:',
    ABOUT_ADVANCED: 'Geavanceerde opties:',
    ABOUT_ADVANCED_STOP: 'Stop tracker',
    ABOUT_ADVANCED_START: 'Start tracker',
    ABOUT_ADVANCED_UPDATE: 'Auto update',
    ABOUT_NEWS: 'Nieuws voor dit project:',
    ABOUT_AGENTS: 'Notificatie agents',
    ABOUT_AGENTS_NONE1: 'Er zijn geen notificatie agents ingesteld in',
    ABOUT_AGENTS_NONE2: 'config.php',
    ABOUT_AGENTS_NONE3: 'Check config.example.php voor het geval deze opties niet in je config.php staan.',
    ABOUT_AGENTS_PROPS: 'Notificatie eigenschappen:',
    ABOUT_AGENTS_USER: 'contact acties',
    ABOUT_AGENTS_TRACKER: 'tracker acties',
    ABOUT_AGENTS_TO: 'naar:',
    ABOUT_AGENTS_RESTART: 'Vergeet niet de tracker te herstarten na een verandering in config.php.',
    ABOUT_QA: 'Vraag en Antwoord',
    CONTROLLER_TIMELINE_1D: '24 uur (beste prestaties)',
    CONTROLLER_TIMELINE_7D: '7  dagen',
    CONTROLLER_TIMELINE_14D: '14 dagen',
    CONTROLLER_TIMELINE_31D: '31 dagen (sloom)',
    CONTROLLER_TIMELINE_90D: '90 dagen (erg sloom)',
    CONTROLLER_CHAR_OPENED: 'geopend',
    CONTROLLER_CHAR_TIMES: 'keer',
    CONTROLLER_CHAR_MINUTES: 'minuten',
    CONTROLLER_COPY: 'Kopieer naar klembord: Ctrl+C en enter.',
    CONTROLLER_WEEKDAY_Sunday: 'Zondag',
    CONTROLLER_WEEKDAY_Monday: 'Maandag',
    CONTROLLER_WEEKDAY_Tuesday: 'Dinsdag',
    CONTROLLER_WEEKDAY_Wednesday: 'Woensdag',
    CONTROLLER_WEEKDAY_Thursday: 'Donderdag',
    CONTROLLER_WEEKDAY_Friday: 'Vrijdag',
    CONTROLLER_WEEKDAY_Saturday: 'Zaterdag',
    CONTROLLER_NONAME: 'Geen naam',
    CONTROLLER_NOTOKEN: 'Niet gedeeld ...',
    CONTROLLER_TRACKER_REASON_NONE: 'niet gegeven',
    CONTROLLER_TIME_DAY: 'd',
    CONTROLLER_TIME_HOURS: 'h',
    CONTROLLER_TIME_MINUTES: 'min',
    CONTROLLER_TIME_SECONDS: 'sec',
    CONTROLLER_SERVER_NO_RES: 'Kan geen contact maken met de server.',
    CONTROLLER_GROUP_NEW: 'Voer een naam in voor deze groep:',
    CONTROLLER_ACCOUNT_DEL: 'Weet je het zeker dat je deze gebruiker wil verwijderen?',
    CONTROLLER_ACCOUNT_REMOVED: ' verwijderd!',
    CONTROLLER_ACCOUNT_UPDATED: 'Contact geupdatet',
    CONTROLLER_ACCOUNT_ADDED: 'Contact toegvoegd aan WhatsSpy Public, het tracken begint binnen 5-10 minuten.',
    CONTROLLER_ACCOUNT_INACTIVE: ' op inactief gezet!',
    CONTROLLER_GROUP_SAVE: 'Groepnaam opgeslagen!',
    CONTROLLER_GROUP_ADD: 'Nieuwe groep aangemaakt.',
    CONTROLLER_GROUP_DEL: 'Groep verwijderd.',
    CONTROLLER_CONFIG_UPDATE: 'Configuratie geupdatet.',
    CONTROLLER_TIME_DAY_FULL: 'dag',
    CONTROLLER_TIME_WEEK_FULL: 'week',
    CONTROLLER_TIME_MONTH_FULL: 'maand',
    CONTROLLER_TIME_CUSTOM_FULL: 'custom',
    CONTROLLER_TIMELINE_HISTORY: 'Geschiedenis:',
    CONTROLLER_TIMELINE_DAYS: 'dag(en)',
    CONTROLLER_TIMELINE_ONLINE: 'Online',
    CONTROLLER_TIMELINE_DURATION: 'Duratie:',
    CONTROLLER_COMPARISON_ALREADY_IN: ' is al in de vergelijking!',
    CONTROLLER_NOTIFICATION_ONLINE: ' is nu online.',
    CONTROLLER_NOTIFICATION_STATUSMSG: ' heeft een nieuw status bericht: ',
    CONTROLLER_NOTIFICATION_PROFPIC: ' heeft een nieuwe profiel foto.',
    CONTROLLER_NOTIFICATION_PIRV_EVERY: 'iedereen',
    CONTROLLER_NOTIFICATION_PRIV_CONTACTS: 'contacten of niemand',
    CONTROLLER_NOTIFICATION_PRIV_LASTSEEN: ' heeft zijn laatst gezien privacy instelling veranderd naar ',
    CONTROLLER_NOTIFICATION_PRIV_PROFPIC: ' heeft zijn profiel foto privacy instelling veranderd naar ',
    CONTROLLER_NOTIFICATION_PRIV_STATUSMSG: ' heeft zijn status bericht privacy instelling veranderd naar ',
    CONTROLLER_NOTIFICATION_TRACKER_START: 'Tracker is gestopt met tracken.',
    CONTROLLER_NOTIFICATION_TRACKER_STOP: 'Tracker is gestop met tracken omdat: ',
    CONTROLLER_STAT_TIMES: 'keer',
    CONTROLLER_CMD0: 'CMD: ',
    CONTROLLER_CMD1: ' resulteerde in: ',
    CONTROLLER_CMD2: ' met output: ',
    PRIVACY_STATUS_EVERYONE: 'iedereen',
    PRIVACY_STATUS_CONTACTS_OR_NOBODY: 'contacten of niemand'
    });
    moment.locale('nl', {
        months : [
            "Januari", "Februari", "Maart", "April", "Mei", "Juni", "Juli",
            "Augustus", "September", "Oktober", "November", "December"
        ],
        monthsShort : [
            "Jan", "Feb", "Mar", "Apr", "Mei", "Jun",
            "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
        ],
        weekdays : [
            "Zondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrijdag", "Zaterdag"
        ],
        weekdaysShort : [
            "Zo", "Ma", "Di", "Wo", "Do", "Fr", "Za"
        ],
        longDateFormat : {
            LT: "h:mm A",
            LTS: "h:mm:ss A",
            L: "MM/DD/YYYY",
            l: "M/D/YYYY",
            LL: "MMMM Do YYYY",
            ll: "MMM D YYYY",
            LLL: "MMMM Do YYYY LT",
            lll: "MMM D YYYY LT",
            LLLL: "dddd, MMMM Do YYYY LT",
            llll: "ddd, MMM D YYYY LT"
        },
        relativeTime : {
            future: "over %s",
            past:   "%s geleden",
            s:  "seconden",
            m:  "een minuut",
            mm: "%d minuten",
            h:  "een uur",
            hh: "%d uren",
            d:  "een dag",
            dd: "%d dagen",
            M:  "een maand",
            MM: "%d maanden",
            y:  "een jaar",
            yy: "%d jaren"
        }
    });


    $translateProvider.translations('de', {
    /* PLEASE NOTE that spaces etc. are all of importance here. You also must escape ' (by using \') */
    /* Use your gitlab/real name here to identify your work */
    TRANSLATOR: 'Robin Kluth',
    MENU_LOGIN: 'Login',
    MENU_OVERVIEW: 'Übersicht',
    MENU_COMPARE: 'Vergleichen',
    MENU_TIMELINE: 'Zeitleiste',
    MENU_STATS: 'Statistiken',
    MENU_ABOUT: 'Über / Hilfe',
    MENU_USER: 'Benutzer',
    MENU_GROUP: 'Gruppe',
    MENU_LOADING: 'Lade neue Daten ...',
    MENU_STATUS: 'Status',
    MENU_TRACKER_ONLINE: 'Tracker online',
    MENU_TRACKER_OFFLINE: 'Tracker offline',
    MENU_TRACKER_NOAUTH: 'nicht eingeloggt',
    MENU_TRACKER_USERS: 'Benutzer',
    MENU_TRACKER_REFRESH: 'Klicken, um Daten zu aktualisieren.',
    MENU_POC: 'Proof of Concept',
    FOOTER_VERSION: 'Version',
    FOOTER_V_BEHIND: 'Nicht aktuell',
    LOGIN_WELCOME: 'Willkommen!',
    LOGIN_WELCOME_MSG: 'Willkommen zum WhatsSpy Public PoC! Bevor du loslegst, lies die',
    LOGIN_LICENSE: 'Lizenz',
    LOGIN_LOGIN_HEAD: 'Login',
    LOGIN_AUTH_NOTIFY: 'Sieht so aus, als ob du nicht angemeldet bist. Bitte anmelden, um auf den Tracker zuzugreifen und zu verwalten.',
    LOGIN_PASS_FIELD: 'Passwort',
    LOGIN_SIGN_IN_BTN: 'Einloggen',
    LOGIN_RESET_BTN: 'Reset',
    LOGIN_PASS_PLACEHOLDER: 'Passwort ...',
    TOKEN_INVALID: 'Ungültiger Schlüssel:',
    OVERVIEW_TOKEN_INVALID: 'Du darfst diesen Benutzer nicht betrachten, da der Token abgelaufen ist.',
    OVERVIEW_TOKEN_INFO_STRONG: 'Geteiltes Benutzerprofil:',
    OVERVIEW_TOKEN_INFO: 'Das ist ein geteiltes Benutzerprofil, erstellt vom Hoster dieser WhatsSpy Public Instanz. Die Zeitleiste enthält nur einige der letzten Status.',
    OVERVIEW_FILTERS: 'Filter',
    OVERVIEW_FILTER_PHONE: 'Nach Nummer suchen ...',
    OVERVIEW_FILTER_NAME_TITLE: 'Nutze z.B. Ben|Anna für mehrere.',
    OVERVIEW_FILTER_NAME: 'Nach Name(n) suchen ...',
    OVERVIEW_INFO_STATUS: 'Das System prüft jeden Status',
    OVERVIEW_INFO_STATUS_FROM: 'von',
    OVERVIEW_INFO_STATUS_CONTACTS: 'Kontakten',
    OVERVIEW_INFO_STATUS_SINCE: 'seit dem',
    OVERVIEW_INFO_PRIV: 'Kontakte, welche "Zuletzt online" auf "Niemand" gesetzt haben, werden',
    OVERVIEW_INFO_PRIV_LINK: 'trotzdem getrackt',
    OVERVIEW_INFO_LIVE: 'Die Infos hier sind nicht live, du kannst sie aktualisieren, indem du den grauen Zeitstempel im "Status"-Panel anklickst.',
    OVERVIEW_INFO_TIMESPAN: 'Außer der Zeitleiste sind alle Informationen seit dem Trackingsdatum eines Kontaktes (wenn nicht anders angegeben).',
    OVERVIEW_INFO_VERIFY: 'Kontakte werden innerhalb von 5-10 Minuten verifiziert,',
    OVERVIEW_INFO_RELOAD: 'Daten neu laden',
    OVERVIEW_INFO_RELOAD_2: 'um erneut zu prüfen.',
    OVERVIEW_ADD: 'Kontakt hinzufügen',
    OVERVIEW_IMPORT: 'Importiere Google Kontakte',
    OVERVIEW_MANAGE_GROUPS: 'Gruppenverwaltung',
    OVERVIEW_MANAGE_PERF: 'Performanceoptionen',
    OVERVIEW_EXPAND: 'Mehr',
    OVERVIEW_COLLAPSE: 'Weniger',
    OVERVIEW_EDIT: 'Bearbeiten',
    OVERVIEW_CONTACT_SINCE: 'Tracking seit',
    OVERVIEW_CONTACT_LASTSEEN: 'Zuletzt online',
    OVERVIEW_CONTACT_NOTIF: 'Benachrichtigungen aktiv',
    OVERVIEW_CONTACT_SHARING: 'Profil geteilt',
    OVERVIEW_NO_INFO: 'Keine Informationen verfügbar ...',
    OVERVIEW_CLICK_LOAD: 'Klicken, um Daten zu laden',
    OVERVIEW_CLICK_LOAD_TIMELINE: 'Lade Zeitleiste',
    OVERVIEW_CONTACT_H_ANALYTICS: 'Analyse / Informationen',
    OVERVIEW_CONTACT_ANALYTICS_OVERVIEW: 'Übersicht',
    OVERVIEW_CONTACT_ANALYTICS_OPENOVERVIEW: 'Geöffnet',
    OVERVIEW_CONTACT_ANALYTICS_TIME_OVERVIEW: 'Zeitübersicht',
    OVERVIEW_CONTACT_ANALYTICS_STATUS: 'Statusnachrichten',
    OVERVIEW_CONTACT_ANALYTICS_PICS: 'Profilbilder',
    OVERVIEW_CONTACT_OPENED_H: 'WhatsApp geöffnet',
    OVERVIEW_CONTACT_TABLE_1D: '(24h) Heute',
    OVERVIEW_CONTACT_TABLE_7D: '(07d) letzten 7 Tage',
    OVERVIEW_CONTACT_TABLE_14D: '(14d) letzten 2 Wochen',
    OVERVIEW_CONTACT_TABLE_31D: '(31d) letzten Monat',
    OVERVIEW_CONTACT_TABLE_xD: '(---) Alles',
    OVERVIEW_CONTACT_TRACKING_SINCE: 'Tracking seit',
    OVERVIEW_CONTACT_TIME_SPENT_WA: 'Zeit in WhatsApp verbracht',
    OVERVIEW_CONTACT_LOADING_INFO: 'Lade Infos ...',
    OVERVIEW_CONTACT_SWITCH_HOUR_VIEW: 'Zeige pro Stunde',
    OVERVIEW_CONTACT_SWITCH_WEEKDAY_VIEW: 'Zeige pro Wochentag',
    OVERVIEW_CONTACT_H_OPENING_WA_WEEKDAY: 'WhatsApp Öffnungen pro Wochentag',
    OVERVIEW_CONTACT_H_OPENING_WA_HOUR: 'WhatsApp Öffnungen pro Stunde',
    OVERVIEW_CONTACT_H_TIME_WA_WEEKDAY: 'Zeit in WhatsApp pro Wochentag',
    OVERVIEW_CONTACT_H_TIME_WA_HOUR: 'Zeit in WhatsApp pro Stunde',
    OVERVIEW_CONTACT_H_PRIV_STATUS: 'Privatsphäre / Online Status',
    OVERVIEW_CONTACT_PRIV_STATUS: 'Privatsphäre',
    OVERVIEW_CONTACT_ONLINE_EVENTS: 'Online-Events',
    OVERVIEW_CONTACT_H_LASTSEEN: 'Zuletzt online',
    OVERVIEW_CONTACT_TIMES: 'Mal',
    OVERVIEW_PRIVACY_SETTINGS_PUBLIC: 'Jeder',
    OVERVIEW_PRIVACY_SETTINGS_FRIENDS: 'Kontakte*',
    OVERVIEW_PRIVACY_LAST_CHANGE: 'geändert zu',
    OVERVIEW_PRIVACY_LAST_CHANGE_AT: 'am',
    OVERVIEW_PRIVACY_H_PROF_PIC: 'Profilbild',
    OVERVIEW_PRIVACY_H_STATUS: 'Status',
    OVERVIEW_PRIVACY_TRACK_NOTICE: 'Profilbilder und Statusnachrichten werden alle 2 Stunden geprüft.',
    OVERVIEW_PRIVACY_ASSUMPTION: 'Es wird angenommen, dass der Benutzer die Tracker-Nummer nicht in seiner Liste hat. Wenn das so ist, wird \'Nur Kontakte\' als \'Jeder\' in dieser Ansicht interpretiert.',
    OVERVIEW_LOG_FROM: 'von',
    OVERVIEW_LOG_TILL: 'bis',
    OVERVIEW_LOG_NOW: 'jetzt',
    OVERVIEW_NO_ACC: 'Keine getrackten Kontakte ...',
    OVERVIEW_ADD_CONTACT_H: 'Füge Kontakt via Nummer hinzu',
    OVERVIEW_ADD_CONTACT_PHONE: 'Telefonnummer',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_COUNTRYCODE: 'Ländercode ...',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_PHONE: 'Nummer ...',
    OVERVIEW_ADD_CONTACT_NAME: 'Kontaktname',
    OVERVIEW_ADD_CONTACT_GROUP: 'Gruppen',
    OVERVIEW_ADD_CONTACT_NOTICE: 'Der neue Kontakt wird als WhatsApp-Nutzer verifiziert und wird danach innerhalb von 5-10 Minuten zum Tracker hinzugefügt. Danach findest du den Kontakt in der Übersicht.',
    OVERVIEW_ADD_CONTACT_ADD: 'Kontakt hinzufügen',
    OVERVIEW_ADD_CONTACT_CLOSE: 'Schließen',
    OVERVIEW_EDIT_CONTACT_H: 'Kontaktname ändern',
    OVERVIEW_EDIT_CONTACT_PHONE: 'Telefonnummer',
    OVERVIEW_EDIT_CONTACT_NAME: 'Kontaktname',
    OVERVIEW_EDIT_CONTACT_NAME_PLACEHOLDER: '(Optional)',
    OVERVIEW_EDIT_CONTACT_GROUPS: 'Gruppen',
    OVERVIEW_EDIT_CONTACT_PROFILESHARE: 'Profil teilen',
    OVERVIEW_EDIT_CONTACT_GENERATE_TOKEN: 'Generieren',
    OVERVIEW_EDIT_CONTACT_RESET_TOKEN: 'Reset',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO: 'URLs von geteilten Profilen funktionieren nur, wenn WhatsSpy Public aus dem Internet aus erreichbar ist.',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO2: 'Klicke auf den Token, um den Link zu kopieren. Generierte Tokens müssen nicht gespeichert werden.',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS: 'Benachrichtigungen',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_ONLINE: 'Kommt Online',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_STATUSMSG: 'Ändert Statusnachricht',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PROFPIC: 'Ändert Profilbild',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PRIV: 'Ändert Privatsphäre-Einstellungen',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS: 'Es sind keine Benachrichtigungs-Agents konfiguriert. Um dies zu tun, schaue in die',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS_CONFIG: 'config.php',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_MISSING: 'Prüfe die config.example.php falls du diese Optionen vermisst.',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_SENDING: 'Sende Benachrichtigungen bei Änderungen via',
    OVERVIEW_AND: 'und',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE: 'Zeige Zeitleisten-Benachrichtigungen (falls offen)',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE_EXPL: 'Benachrichtigungston in der Zeitleiste für diesen Benutzer.',
    OVERVIEW_EDIT_CONTACT_SAVE: 'Kontakt speichern',
    OVERVIEW_EDIT_CONTACT_INACTIVE: 'Inaktiv setzen',
    OVERVIEW_EDIT_CONTACT_DELETE: 'Kontakt löschen (!)',
    OVERVIEW_EDIT_CONTACT_DETELE_TITLE: 'Löscht alle Informationen dieses Kontakts, samt allen Status-Aufzeichnungen.',
    OVERVIEW_EDIT_CONTACT_INACTIVE_TITLE: 'Trackt den Benutzer nicht, aber behält Status-/Privatsphäreänderungen im Blick. Diese Änderung kann ca. eine Stunde dauern, bis sie übernommen wird.',
    OVERVIEW_GROUPS_H: 'Gruppenverwaltung',
    OVERVIEW_GROUPS_EXISTING: 'Existierende Gruppen',
    OVERVIEW_GROUPS_USERS: 'Benutzer:',
    OVERVIEW_GROUPS_STATSEN: 'Statistik teilen aktiv',
    OVERVIEW_GROUPS_STATSDIS: 'Teilen deaktiviert*',
    OVERVIEW_GROUPS_NONE: 'Keine Gruppen definiert...',
    OVERVIEW_GROUPS_SHARE: '* Du kannst Gruppenstatistik auf der "Statistiken"-Seite teilen.',
    OVERVIEW_GROUPS_DELETE: '** Das löschen der Gruppe löscht keine Kontakte in der Gruppe.',
    OVERVIEW_GROUPS_DELETEBTN: 'Gruppe löschen**',
    OVERVIEW_GROUPS_CREATE: 'Gruppe anlegen',
    OVERVIEW_GROUPS_CREATE_NAME: 'Gruppenname',
    OVERVIEW_GROUPS_CREATEBTN: 'Gruppe erstellen',
    OVERVIEW_GROUPS_PLACEHOLDER: 'Name der Gruppe (benötigt)',
    OVERVIEW_GROUPS_CLOSE: 'Schließen',
    OVERVIEW_PERFORMANCE_H: 'UI-Performance verwalten',
    OVERVIEW_PERFORMANCE_TIMELINE: 'Zeitleiste',
    OVERVIEW_PERFORMANCE_TIMELINE_OPTION: 'Zeige:',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP: 'Diese Einstellung hat',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP2: 'große',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP3: 'Auswirkungen auf die Performance wenn die Kontakt-Zeitleiste (neu) geladen wird. Betrifft die Übersicht, Vergleichen und die geteilten Profilseiten.',
    OVERVIEW_PERFORMANCE_TRACKER_H: 'Tracker Sitzungen',
    OVERVIEW_PERFORMANCE_TRACKER_OPTION: 'In der Zeitleiste anzeigen',
    OVERVIEW_PERFORMANCE_TRACKER_EXP: 'Diese Einstellung hat',
    OVERVIEW_PERFORMANCE_TRACKER_EXP2: 'wenig',
    OVERVIEW_PERFORMANCE_TRACKER_EXP3: 'Auswirkungen auf die Performance wenn die Kontakt-Zeitleiste (neu) geladen wird. Betrifft Übersicht und Vergleichen.',
    OVERVIEW_PERFORMANCE_SAVE: 'Speichern',
    OVERVIEW_PERFORMANCE_CLOSE: 'Schließen',
    COMPARE_SELECT: 'Kandidaten wählen',
    COMPARE_ADD_TO_COMPARE: 'Benutzer zum Vergleich hinzufügen',
    COMPARE_ADD: 'Hinzufügen',
    COMPARE_ADD_GROUP_COMPARE: 'Gruppe zum Vergleich hinzufügen',
    COMPARE_ADD_NOTICE: 'Große Gruppen können, aufgrund der Datenmenge, zum kurzen Einfrieren des Browsers führen.',
    COMPARE_CURR_LIST: 'Aktuelle Kandidaten im Vergleich:',
    COMPARE_CURR_LIST_INFO: 'Kandidat- / Privatsphäreeinstellungen',
    COMPARE_LASTSEEN: 'Zuletzt online:',
    COMPARE_STATUSMSG: 'Statusnachricht:',
    COMPARE_PROFPIC: 'Profilbild:',
    COMPARE_REMOVE: 'Entfernen',
    COMPARE_LOADING: 'Lade Kontoinformationen ...',
    COMPARE_CONTACTS: 'Kontakte*',
    COMPARE_EVERYBODY: 'Jeder',
    COMPARE_CONTACTS_NOTICE: 'Entweder auf Nur Kontakte oder Niemand gesetzt. Das kann nicht ermittelt werden.',
    STATS_TOKEN_INFO: 'Du kannst diese Gruppe nicht ansehen, da der Token ungültig ist.',
    STATS_TOKEN_GROUP: 'Geteiltes Gruppenprofil:',
    STATS_TOKEN_GROUP_INFO: 'Das sind geteilte Statistiken der Gruppe',
    STATS_TOKEN_GROUP_INFO2: 'erstellt vom Hoster dieser WhatsSpy Public-Instanz.',
    STATS_NO_INFO: 'Nicht genügend Informationen verfügbar ...',
    STATS_LOADING: 'Lade Informationen ...',
    STATS_FILTER: 'Filteroptionen',
    STATS_NOTES: 'Bemerkungen',
    STATS_INFO_VALIDITY: 'Es werden keine Informationen auf dieser Seite aktualisiert. Du kannst die Seite mit einem Klick auf den grauen Zeitstempel im "Status"-Panel aktualisieren.',
    STATS_TOKEN_GEN: 'Generieren',
    STATS_TOKEN_RESET: 'Reset',
    STATS_SHARE_INFO: 'URLs von geteilten Statistiken funktionieren nur, wenn WhatsSpy Public aus dem Internet aus erreichbar ist. Klicke auf den Token, um den Link zu kopieren.',
    STATS_H: 'WhatsSpy Public Statistiken',
    STATS_TRACKER_STATUS: 'Trackerstatus',
    STATS_SESSION: 'Tracker Sitzungen',
    STATS_FIRST_SESSION: 'Erster Tracker-Start (Erste Informationaufzeichnung)',
    STATS_DB_CONTENT: 'Datenbankinhalt',
    STATS_NUMBER_OF_ACC: 'Anzahl von Accounts',
    STATS_ACCOUNTS: 'Accounts',
    STATS_STATUSES: 'Status',
    STATS_PROFPIC: 'Profilbilder',
    STATS_STSMSG: 'Statusnachrichten',
    STATS_H_ONLINE: 'Online/Offline Status aufgezeichnet',
    STATS_H_TOTALTIME: 'Gesamtzeit, die alle Kontakte in WhatsApp verbracht haben',
    STATS_H_PROFPICSUM: 'Profilbilder aufgezeichnet',
    STATS_H_STATUSMSGSUM: 'Statusnachrichten aufgezeichnet',
    STATS_H_PRIVACY: 'Privatsphäre',
    STATS_PRIVACY_H: 'Privatsphäreeinstellungen von getrackten Kontakten',
    STATS_PRIVACY_TABLE_TH1: 'Option',
    STATS_PRIVACY_TABLE_TH2: 'Kontakte/Niemand',
    STATS_PRIVACY_TABLE_TH3: 'Jeder',
    STATS_PRIVACY_OPTION1: 'Zuletzt Online*',
    STATS_PRIVACY_OPTION2: 'Statusnachrichten',
    STATS_PRIVACY_OPTION3: 'Profilbilder',
    STATS_PRIVACY_USERS: 'Benutzer',
    STATS_PRIVACY_HISTORY: 'Privatsphärenänderung während Tracking',
    STATS_PRIVACY_LASTSEEN: 'Zuletzt Online',
    STATS_PRIVACY_CHANGE: 'Änderungen',
    STATS_PRIVACY_PROFPIC: 'Profilbild',
    STATS_PRIVACY_STATUSMSG: 'Statusnachricht',
    STATS_PRIVACY_INFO1: '* Die Zuletzt Online Option schützt nicht vor Erkennung des Online/Offline Status. Schau dir',
    STATS_PRIVACY_INFO2: 'diesen Artikel',
    STATS_PRIVACY_INFO3: 'an. Hier wird das Problem im Detail besprochen.',
    STATS_PIE_CHART_ONLINE_TIME_H: 'WhatsApp Nutzung (Online-Zeit / Öffnungen) verglichen pro Benutzer',
    STATS_PIE_CHART_TODAY: 'Heute',
    STATS_PIE_CHART_7DAYS: '7 Tage',
    STATS_PIE_CHART_14DAYS: '14 Tage',
    STATS_PIE_CHART_ALL: 'Alles',
    STATS_PIE_CHART_PIE_OPEN_H_ALL: 'WhatsApp geöffnet - Alles',
    STATS_PIE_CHART_PIE_OPEN_H_7DAYS: 'WhatsApp geöffnet - Letzten 7 Tage',
    STATS_PIE_CHART_PIE_OPEN_H_14DAYS: 'WhatsApp geöffnet - Letzten 14 Tage',
    STATS_PIE_CHART_PIE_OPEN_H_TODAY: 'WhatsApp geöffnet - Heute',
    STATS_PIE_CHART_PIE_ONLINE_H_ALL: 'Zeit verbracht in WhatsApp - Alles',
    STATS_PIE_CHART_PIE_ONLINE_H_7DAYS: 'Zeit verbracht in WhatsApp - Letzten 7 Tage',
    STATS_PIE_CHART_PIE_ONLINE_H_14DAYS: 'Zeit verbracht in WhatsApp - Letzten 14 Tage',
    STATS_PIE_CHART_PIE_ONLINE_H_TODAY: 'Zeit verbracht in WhatsApp - Heute',
    STATS_PIE_CHART_PIE_INFO: 'Bitte beachte, dass jede Online-Sitzung ca 0-4 Sekunden (bedingt durch WhatsApp, deinem Server und deiner Internetverbindung) abweichen kann. Daher sind all diese Informationen das Maximum an Zeit welche in WhatsApp verbracht wurde.',
    STATS_PIE_CHART_BAR_H: 'WhatsApp Nutzung (Online-Zeit / Öffnungen) verglichen pro Zeiteinheit',
    STATS_PIE_CHART_BAR_OPEN_H_WEEKDAY: 'WhatsApp geöffnet pro Wochentag',
    STATS_PIE_CHART_BAR_OPEN_H_HOUR: 'WhatsApp geöffnet pro Stunde',
    STATS_PIE_CHART_BAR_SHOWHOUR: 'Zeige pro Stunde',
    STATS_PIE_CHART_BAR_SHOWWEEKDAY: 'Zeige pro Wochentag',
    STATS_PIE_CHART_BAR_TIME_H_WEEKDAY: 'Zeit verbracht in WhatsApp pro Wochentag',
    STATS_PIE_CHART_BAR_TIME_H_HOUR: 'Zeit verbracht in WhatsApp pro Stunde',
    STATS_BAR_CHART_TODAY: 'Heute',
    STATS_BAR_CHART_7DAYS: '7 Tage',
    STATS_BAR_CHART_14DAYS: '14 Tage',
    STATS_BAR_CHART_ALLTIME: 'Alles',
    STATS_TOP_H1: 'Top',
    STATS_TOP_H2: 'getrackte Nutzer',
    STATS_TOP_ALL_SHOW: 'Zeige alle',
    STATS_TOP_H3: 'am meißsten aktive Benutzer pro Tag',
    STATS_TOP_DAYS_AGO: 'Tage zuvor',
    STATS_TOP_YESTERDAY: 'Gestern',
    STATS_TOP_TODAY: 'Heute',
    STATS_TOP_TRACKED_CONTACT: 'Kontakt',
    STATS_TOP_TIME: 'Onlinezeit',
    STATS_TOP_OPENED: 'WA Öffnungen',
    STATS_TOP_TIMES: 'Mal',
    STATS_TOP_H4: 'Insgesamt am meisten aktiv',
    STATS_TOP_ALL: 'Alles',
    STATS_TOP_DAYS: 'Tage',
    STATS_TOP_HOURS: 'Stunden',
    STATS_TYPE_today: 'Heute',
    STATS_TYPE_yesterday: 'Gestern',
    STATS_TYPE_2days_ago: 'Vor 2 Tagen',
    STATS_TYPE_3days_ago: 'Vor 3 Tagen',
    STATS_TYPE_4days_ago: 'Vor 4 Tagen',
    STATS_TYPE_alltime: 'Alles',
    STATS_TYPE_31days: '31 Tage',
    STATS_TYPE_14days: '14 Tage',
    STATS_TYPE_7days: '7 Tage',
    STATS_TYPE_24hours: '24 Stunden',
    TIMELINE_FILTER: 'Filter',
    TIMELINE_FILTER_PHONE_PLACEHOLDER: 'Suche nach Nummer ...',
    TIMELINE_FILTER_NAME_PLACEHOLDER: 'Benutzer z.B. Ben|Max für mehrere.',
    TIMELINE_SEARCH_NAME: 'Nach Name suchen ...',
    TIMELINE_INFO_STATUS: 'Das System prüft jeden Status',
    TIMELINE_INFO_FROM: 'von',
    TIMELINE_INFO_CONTACTS: 'Kontakten',
    TIMELINE_INFO_CONTINIOUS: 'kontinuierlich seit',
    TIMELINE_INFO_LASTSTATUS: 'Kontakte, welche "Zuletzt online" auf "Niemand" gesetzt haben, werden',
    TIMELINE_INFO_LASTSTATUS2: 'trotzdem getrackt',
    TIMELINE_INFO_LIVE: 'Anders als die Übersichtsseite und dem Vergleich, sind diese Infos hier Live.',
    TIMELINE_FILTER_NOTIFY: 'Benachrichtige für jedes Event (mit Filter)',
    TIMELINE_FILTER_TRACKER: 'Zeige Tracker-Events',
    TIMELINE_ACTIVITY_H: 'Aktivitätszeitleiste',
    TIMELINE_STATUS_H: 'Statuszeitleiste',
    TIMELINE_ACTIVITY_TIMESPAN1: 'Aktivitätszeitleiste',
    TIMELINE_ACTIVITY_TIMESPAN2: 'von',
    TIMELINE_ACTIVITY_TIMESPAN3: 'bis jetzt',
    TIMELINE_ACTIVITY_TRACKERSTART: 'Tracker ist jetzt Online',
    TIMELINE_ACTIVITY_TRACKERSTART_STARTED: 'gestartet am',
    TIMELINE_ACTIVITY_TRACKERSTOP: 'Tracker ist jetzt Offline',
    TIMELINE_ACTIVITY_TRACKERSTOP_SESSION: 'Diese Sitzung dauerte von',
    TIMELINE_ACTIVITY_TRACKERSTOP_TILL: 'bis',
    TIMELINE_ACTIVITY_TRACKERSTOP_REASON: 'Grund:',
    TIMELINE_ACTIVITY_TRACKERSTOP_SUPPORT: 'Support für generelle Probleme',
    TIMELINE_ACTIVITY_STATUSMSG: 'Neue Statusnachricht für',
    TIMELINE_ACTIVITY_STATUSMSG_TO: 'geändert zu',
    TIMELINE_ACTIVITY_PROFPIC: 'Neues Profilbild für',
    TIMELINE_ACTIVITY_PROFPIC_TITLE: 'Das erkennen neuer Profilbilder kann 0-4 Stunden dauern.',
    TIMELINE_ACTIVITY_PRIV: 'hat die Privatsphäre-Einstellungen geändert',
    TIMELINE_ACTIVITY_PRIV_OPTION: 'Option',
    TIMELINE_ACTIVITY_PRIV_LASTSEEN: 'Zuletzt Online',
    TIMELINE_ACTIVITY_PRIV_SETTO: 'ist jetzt gesetzt auf',
    TIMELINE_ACTIVITY_PRIV_CONTACTS: 'Kontakte*',
    TIMELINE_ACTIVITY_PRIV_EVERYONE: 'Jeder',
    TIMELINE_ACTIVITY_PRIV_CONTACTSTITLE: 'Diese Option kann Kontakte oder Niemand sein. Das kann nicht erkannt werden.',
    TIMELINE_ACTIVITY_PRIV_PROFPIC: 'Profilbild',
    TIMELINE_ACTIVITY_PRIV_STATUSMSG: 'Statusnachricht',
    TIMELINE_ACTIVITY_NOINFO: 'Keine Infos verfügbar ...',
    TIMELINE_ACTIVITY_LOADMORE: 'Klicke, um 7 weitere Tage zu laden ...',
    TIMELINE_STATUS_ONLINE: 'Online von',
    TIMELINE_STATUS_TILL: 'bis',
    TIMELINE_STATUS_NOINFO: 'Keine Informationen verfügbar ...',
    TIMELINE_STATUS_NOINFOFILTER: 'Keine aktuellen Nutzerinfos für diesen Filter ...',
    ABOUT_LICENSE0: 'WhatsSpy Public ist ein Proof of Concept um zu zeigen, wie schlecht die WhatsApp-Datenschutz Optionen sind. Mit diesem Tool, kannst du im Grunde das Verhalten von jedem verfolgen, indem du nur seine Nummer kennst. Das Tool ist nur für Proof of Concept Verwendungen! Bitte lies die',
    ABOUT_LICENSE1: 'Lizenz',
    ABOUT_LICENSE2: 'welche für dieses PoC gilt!',
    ABOUT_DONATION0: 'Du kannst das Projekt mit einer kleinen Spende gern unterstützen:',
    ABOUT_DONATION1: 'Bitcoin:',
    ABOUT_DONATION2: 'oder via',
    ABOUT_DONATION3: 'PayPal',
    ABOUT_INFO: 'Allgemeine Informationen',
    ABOUT_VERSION: 'Version:',
    ABOUT_UPDATE: 'ist verfügbar.',
    ABOUT_UPTODATE: 'Diese Version ist aktuell.',
    ABOUT_UPDATE_NOW: 'Update',
    ABOUT_UPDATE_LOG: 'Updatelog und wie geupdatet wird',
    ABOUT_WIKI: 'Wiki / Source:',
    ABOUT_WIKI_LINK: 'Gitlab Wiki',
    ABOUT_FAQ: 'FAQ:',
    ABOUT_FAQ_LINK: 'Frequently Asked Questions',
    ABOUT_TROUBLE: 'Troubleshooting:',
    ABOUT_TROUBLE_LINK: 'Troubleshooting',
    ABOUT_OPTIONS: 'Optionen:',
    ABOUT_OPTIONS_LOGOUT: 'Logout',
    ABOUT_LANGUAGE: 'Sprache:',
    ABOUT_ADVANCED: 'Erweiterte Optionen:',
    ABOUT_ADVANCED_STOP: 'Tracker stoppen',
    ABOUT_ADVANCED_START: 'Tracker starten',
    ABOUT_ADVANCED_UPDATE: 'Auto update',
    ABOUT_NEWS: 'News für dieses Projekt:',
    ABOUT_AGENTS: 'Benachrichtigungs-Agents',
    ABOUT_AGENTS_NONE1: 'Es sind keine Benachrichtigungs-Agents konfiguriert. Schau in die',
    ABOUT_AGENTS_NONE2: 'config.php',
    ABOUT_AGENTS_NONE3: 'Schaue in die config.example.php falls du diese Optionen vermisst.',
    ABOUT_AGENTS_PROPS: 'Benachrichtigungsoptionen:',
    ABOUT_AGENTS_USER: 'Benutzeraktionen',
    ABOUT_AGENTS_TRACKER: 'Tracker Aktionen',
    ABOUT_AGENTS_TO: 'an:',
    ABOUT_AGENTS_RESTART: 'Vergiss nicht nach jeder Änderung in der config.php den Tracker neu zu starten ;)',
    ABOUT_QA: 'Fragen und Antworten',
    CONTROLLER_TIMELINE_1D: '24 Stunden (beste Performance)',
    CONTROLLER_TIMELINE_7D: '7  Tage',
    CONTROLLER_TIMELINE_14D: '14 Tage',
    CONTROLLER_TIMELINE_31D: '31 Tage (langsam)',
    CONTROLLER_TIMELINE_90D: '90 Tage (sehr langsam)',
    CONTROLLER_CHAR_OPENED: 'Öffnete',
    CONTROLLER_CHAR_TIMES: 'Mal',
    CONTROLLER_CHAR_MINUTES: 'Minuten',
    CONTROLLER_COPY: 'Kopieren: Ctrl+C, Enter',
    CONTROLLER_WEEKDAY_Sunday: 'Sonntag',
    CONTROLLER_WEEKDAY_Monday: 'Montag',
    CONTROLLER_WEEKDAY_Tuesday: 'Dienstag',
    CONTROLLER_WEEKDAY_Wednesday: 'Mittwoch',
    CONTROLLER_WEEKDAY_Thursday: 'Donnerstag',
    CONTROLLER_WEEKDAY_Friday: 'Freitag',
    CONTROLLER_WEEKDAY_Saturday: 'Samstag',
    CONTROLLER_NONAME: 'kein Name',
    CONTROLLER_NOTOKEN: 'Nicht geteilt ...',
    CONTROLLER_TRACKER_REASON_NONE: 'unbekannt',
    CONTROLLER_TIME_DAY: 'T ',
    CONTROLLER_TIME_HOURS: 'S ',
    CONTROLLER_TIME_MINUTES: 'Min ',
    CONTROLLER_TIME_SECONDS: 'Sek',
    CONTROLLER_SERVER_NO_RES: 'Kann Server nicht kontaktieren.',
    CONTROLLER_GROUP_NEW: 'Gib den neuen Namen der Gruppe ein:',
    CONTROLLER_ACCOUNT_DEL: 'Sicher, dass du dieses Konto löschen möchtest?',
    CONTROLLER_ACCOUNT_REMOVED: 'Gelöscht!',
    CONTROLLER_ACCOUNT_UPDATED: 'Kontakt aktualisiert',
    CONTROLLER_ACCOUNT_ADDED: 'Kontakt zu WhatsSpy hinzugefügt. Tracken startet in 5-10 Minuten.',
    CONTROLLER_ACCOUNT_INACTIVE: ' auf inaktiv gesetzt!',
    CONTROLLER_GROUP_SAVE: 'Neuer Gruppenname gesichert!',
    CONTROLLER_GROUP_ADD: 'Neue Gruppe hinzugefügt.',
    CONTROLLER_GROUP_DEL: 'Gruppe gelöscht.',
    CONTROLLER_CONFIG_UPDATE: 'Konfiguration aktualisiert.',
    CONTROLLER_TIME_DAY_FULL: 'Tag',
    CONTROLLER_TIME_WEEK_FULL: 'Woche',
    CONTROLLER_TIME_MONTH_FULL: 'Monat',
    CONTROLLER_TIME_CUSTOM_FULL: 'Eigene',
    CONTROLLER_TIMELINE_HISTORY: 'Historie:',
    CONTROLLER_TIMELINE_DAYS: 'Tag(e)',
    CONTROLLER_TIMELINE_ONLINE: 'Online',
    CONTROLLER_TIMELINE_DURATION: 'Dauer:',
    CONTROLLER_COMPARISON_ALREADY_IN: ' ist bereits im Vergleich!',
    CONTROLLER_NOTIFICATION_ONLINE: ' ist jetzt Online.',
    CONTROLLER_NOTIFICATION_STATUSMSG: ' hat einen neues Status: ',
    CONTROLLER_NOTIFICATION_PROFPIC: ' hat ein neues Profilbild.',
    CONTROLLER_NOTIFICATION_PIRV_EVERY: 'Jeder',
    CONTROLLER_NOTIFICATION_PRIV_CONTACTS: 'Kontakte oder Niemand',
    CONTROLLER_NOTIFICATION_PRIV_LASTSEEN: ' hat Zuletzt-Online geändert zu ',
    CONTROLLER_NOTIFICATION_PRIV_PROFPIC: ' hat Profilbild geändert zu ',
    CONTROLLER_NOTIFICATION_PRIV_STATUSMSG: ' hat Statusnachricht Privatsphäreneinstellung geändert zu ',
    CONTROLLER_NOTIFICATION_TRACKER_START: 'Tracker wurde gestartet.',
    CONTROLLER_NOTIFICATION_TRACKER_STOP: 'Tracker wurde gestoppt. Grund: ',
    CONTROLLER_STAT_TIMES: 'Mal',
    CONTROLLER_CMD0: 'CMD: ',
    CONTROLLER_CMD1: ' Ergab Code: ',
    CONTROLLER_CMD2: ' mit Ausgabe: ',
    PRIVACY_STATUS_EVERYONE: 'Jeder',
    PRIVACY_STATUS_CONTACTS_OR_NOBODY: 'Kontakte oder Niemand'
    });
    moment.locale('de', {
        months : [
            "Januar", "Februar", "März", "April", "Mai", "Juni", "Juli",
            "August", "September", "Oktober", "November", "Dezember"
        ],
        monthsShort : [
            "Jan", "Feb", "Mär", "Apr", "Mai", "Jun",
            "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"
        ],
        weekdays : [
            "Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"
        ],
        weekdaysShort : [
            "So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"
        ],
        longDateFormat : {
            LT: "h:mm A",
            LTS: "h:mm:ss A",
            L: "MM/DD/YYYY",
            l: "M/D/YYYY",
            LL: "MMMM Do YYYY",
            ll: "MMM D YYYY",
            LLL: "MMMM Do YYYY LT",
            lll: "MMM D YYYY LT",
            LLLL: "dddd, MMMM Do YYYY LT",
            llll: "ddd, MMM D YYYY LT"
        },
        relativeTime : {
            future: "in %s",
            past:   "vor %s",
            s:  "ein paar Sekunden",
            m:  "einer Minute",
            mm: "%d Minuten",
            h:  "einer Stunde",
            hh: "%d Stunden",
            d:  "einem Tag",
            dd: "%d Tagen",
            M:  "einem Monat",
            MM: "%d Monaten",
            y:  "einem Jahr",
            yy: "%d Jahren"
        }
    });

    $translateProvider.translations('es', {
    /* PLEASE NOTE that spaces etc. are all of importance here. You also must escape ' (by using \') */
    /* Traduccion al español por Javier Andres Tolosa Rivera  Colombia */
    TRANSLATOR: 'Javier Andres Tolosa Rivera',
    MENU_LOGIN: 'Iniciar Sesion',
    MENU_OVERVIEW: 'Info General',
    MENU_COMPARE: 'Comparar',
    MENU_TIMELINE: 'Cronologia',
    MENU_STATS: 'Estadisticas',
    MENU_ABOUT: 'Ayuda',
    MENU_USER: 'Usuario Publico',
    MENU_GROUP: 'Grupo Publico',
    MENU_LOADING: 'Cargando Datos Nuevos ...',
    MENU_STATUS: 'Estado',
    MENU_TRACKER_ONLINE: 'Rastreador en linea',
    MENU_TRACKER_OFFLINE: 'Rastreador Apagado',
    MENU_TRACKER_NOAUTH: 'No Autenticado',
    MENU_TRACKER_USERS: 'Usuarios',
    MENU_TRACKER_REFRESH: 'Haga clic aqui para actualizar los datos cargados en la web-app.',
    MENU_POC: 'Prueba de Concepto',
    FOOTER_VERSION: 'Version',
    FOOTER_V_BEHIND: 'Desactualizada',
    LOGIN_WELCOME: 'Bienvenido!',
    LOGIN_WELCOME_MSG: 'Bienvenido a WhatsSpy PoC Publico ! Antes de iniciar el seguimiento por favor lea la',
    LOGIN_LICENSE: 'Licencia',
    LOGIN_LOGIN_HEAD: 'Iniciar Sesion',
    LOGIN_AUTH_NOTIFY: 'Parece que no se ha autenticado. Inicie sesion para ver y administrar el rastreador.',
    LOGIN_PASS_FIELD: 'Clave',
    LOGIN_SIGN_IN_BTN: 'Registrarse',
    LOGIN_RESET_BTN: 'Reiniciar',
    LOGIN_PASS_PLACEHOLDER: 'Clave ...',
    TOKEN_INVALID: 'Ficha Invalida:',
    OVERVIEW_TOKEN_INVALID: 'No tienes permiso para ver este usuario porque el token no es valido.',
    OVERVIEW_TOKEN_INFO_STRONG: 'Perfil de Usuario Compartido:',
    OVERVIEW_TOKEN_INFO: 'Este es un perfil de usuario compartido creado por el proveedor de alojamiento en esta Instancia WhatsSpy publico. La linea de tiempo contiene solo una instantanea de los ultimos estados.',
    OVERVIEW_FILTERS: 'Filtros',
    OVERVIEW_FILTER_PHONE: 'Buscar por numero de telefono ...',
    OVERVIEW_FILTER_NAME_TITLE: 'Use el nombre | para filtrar en multiples nombres.',
    OVERVIEW_FILTER_NAME: 'Buscar por Nombre ...',
    OVERVIEW_INFO_STATUS: 'El Sistema Esta Comprobando Todos los Estados',
    OVERVIEW_INFO_STATUS_FROM: 'De',
    OVERVIEW_INFO_STATUS_CONTACTS: 'Contactos',
    OVERVIEW_INFO_STATUS_SINCE: 'Desde',
    OVERVIEW_INFO_PRIV: 'Contactos que han configurado "vista por ultima vez" para no ser visto por "nadie" seran',
    OVERVIEW_INFO_PRIV_LINK: 'Seguidos de Todos Modos',
    OVERVIEW_INFO_LIVE: 'La informacion de esta pagina no es online, puede volver a cargar esta pagina haciendo clic en la marca de tiempo gris en el panel de "Estado".',
    OVERVIEW_INFO_TIMESPAN: 'Al lado de la linea de tiempo, toda la informacion es de desde que comenzo el seguimiento de este contacto (Salvo se Indique lo Contrario).',
    OVERVIEW_INFO_VERIFY: 'Contactos se Verificaran Dentro de 5-10 Minutos',
    OVERVIEW_INFO_RELOAD: 'Recargar Datos',
    OVERVIEW_INFO_RELOAD_2: 'Para Comprobar de Nuevo.',
    OVERVIEW_ADD: 'Agregar Contacto',
    OVERVIEW_IMPORT: 'Importarlos de Google',
    OVERVIEW_MANAGE_GROUPS: 'Administrar Grupos',
    OVERVIEW_MANAGE_PERF: 'Opciones de Rendimiento',
    OVERVIEW_EXPAND: 'Expandir Vista',
    OVERVIEW_COLLAPSE: 'Contraer Vista',
    OVERVIEW_EDIT: 'Editar',
    OVERVIEW_CONTACT_SINCE: 'Seguimiento Desde',
    OVERVIEW_CONTACT_LASTSEEN: 'Ultima Vista',
    OVERVIEW_CONTACT_NOTIF: 'Notificaciones Habilitadas',
    OVERVIEW_CONTACT_SHARING: 'Compartir Perfil Habilitado',
    OVERVIEW_NO_INFO: 'No hay Informacion Disponible ..',
    OVERVIEW_CLICK_LOAD: 'Clic Para Cargar Datos',
    OVERVIEW_CLICK_LOAD_TIMELINE: 'Cargar linea de Tiempo',
    OVERVIEW_CONTACT_H_ANALYTICS: 'Analisis / Informacion',
    OVERVIEW_CONTACT_ANALYTICS_OVERVIEW: 'Descripcion General',
    OVERVIEW_CONTACT_ANALYTICS_OPENOVERVIEW: 'Vision General Abierta',
    OVERVIEW_CONTACT_ANALYTICS_TIME_OVERVIEW: 'Resumen de Tiempo',
    OVERVIEW_CONTACT_ANALYTICS_STATUS: 'Mensajes de Estado',
    OVERVIEW_CONTACT_ANALYTICS_PICS: 'Fotos de Perfil',
    OVERVIEW_CONTACT_OPENED_H: 'Cliente WhatsApp Iniciado',
    OVERVIEW_CONTACT_TABLE_1D: '(24h) Hoy',
    OVERVIEW_CONTACT_TABLE_7D: '(07d) Los Ultimos 7 Dias',
    OVERVIEW_CONTACT_TABLE_14D: '(14d) Ultimas Dos Semanas',
    OVERVIEW_CONTACT_TABLE_31D: '(31d) El Mes Pasado',
    OVERVIEW_CONTACT_TABLE_xD: '(---) Todo El Tiempo',
    OVERVIEW_CONTACT_TRACKING_SINCE: 'Seguimiento Desde',
    OVERVIEW_CONTACT_TIME_SPENT_WA: 'El Tiempo Dedicado a WhatsApp',
    OVERVIEW_CONTACT_LOADING_INFO: 'Cargando Informacion ...',
    OVERVIEW_CONTACT_SWITCH_HOUR_VIEW: 'Mostrar por Hora',
    OVERVIEW_CONTACT_SWITCH_WEEKDAY_VIEW: 'Mostrar por dia de la Semana',
    OVERVIEW_CONTACT_H_OPENING_WA_WEEKDAY: 'Apertura de WhatsApp por dia de la Semana',
    OVERVIEW_CONTACT_H_OPENING_WA_HOUR: 'Apertura de WhatsApp por Hora',
    OVERVIEW_CONTACT_H_TIME_WA_WEEKDAY: 'Tiempo en WhatsApp por dia de la Semana',
    OVERVIEW_CONTACT_H_TIME_WA_HOUR: 'Tiempo en WhatsApp por Hora',
    OVERVIEW_CONTACT_H_PRIV_STATUS: 'Privacidad / Estado Online',
    OVERVIEW_CONTACT_PRIV_STATUS: 'Privacidad',
    OVERVIEW_CONTACT_ONLINE_EVENTS: 'Eventos en Linea',
    OVERVIEW_CONTACT_H_LASTSEEN: 'Ultima Vista',
    OVERVIEW_CONTACT_TIMES: 'Veces',
    OVERVIEW_PRIVACY_SETTINGS_PUBLIC: 'Todos',
    OVERVIEW_PRIVACY_SETTINGS_FRIENDS: 'Contactos*',
    OVERVIEW_PRIVACY_LAST_CHANGE: 'Cambiado a',
    OVERVIEW_PRIVACY_LAST_CHANGE_AT: 'a',
    OVERVIEW_PRIVACY_H_PROF_PIC: 'Foto de Perfil',
    OVERVIEW_PRIVACY_H_STATUS: 'Mensajes de Estado',
    OVERVIEW_PRIVACY_TRACK_NOTICE: 'Imagen de Perfil y Mensaje de Estado son Revisados Cada 2 Horas.',
    OVERVIEW_PRIVACY_ASSUMPTION: 'Suponiendo que este Usuario no tiene el Numero de Seguimiento en su lista de Contactos. Si este es el caso \'Solo Contactos\' Se Interpretara Como \'Todos\' en Esta Vista.',
    OVERVIEW_LOG_FROM: 'Desde',
    OVERVIEW_LOG_TILL: 'Hasta',
    OVERVIEW_LOG_NOW: 'Ahora',
    OVERVIEW_NO_ACC: 'No hay Cuentas de Seguimiento ..',
    OVERVIEW_ADD_CONTACT_H: 'Agregar Contacto por Telefono',
    OVERVIEW_ADD_CONTACT_PHONE: 'Numero de Telefono',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_COUNTRYCODE: 'Codigo de Pais ...',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_PHONE: 'Numero de Telefono ...',
    OVERVIEW_ADD_CONTACT_NAME: 'Nombre de Contacto',
    OVERVIEW_ADD_CONTACT_GROUP: 'Grupos',
    OVERVIEW_ADD_CONTACT_NOTICE: 'El nuevo contacto sera verificado como usuario de WhatsApp y agregado al  rastreador dentro de 5-10 minutos. Despues de esto se puede encontrar el contacto en la lista de resumen.',
    OVERVIEW_ADD_CONTACT_ADD: 'Agregar Contacto',
    OVERVIEW_ADD_CONTACT_CLOSE: 'Cerrar',
    OVERVIEW_EDIT_CONTACT_H: 'Editar Nombre Contacto',
    OVERVIEW_EDIT_CONTACT_PHONE: 'Numero de Telefono',
    OVERVIEW_EDIT_CONTACT_NAME: 'Nombre de Contacto',
    OVERVIEW_EDIT_CONTACT_NAME_PLACEHOLDER: '(opcional) Nombre de Contacto',
    OVERVIEW_EDIT_CONTACT_GROUPS: 'Grupos',
    OVERVIEW_EDIT_CONTACT_PROFILESHARE: 'Compartir el Perfil',
    OVERVIEW_EDIT_CONTACT_GENERATE_TOKEN: 'Generar',
    OVERVIEW_EDIT_CONTACT_RESET_TOKEN: 'Reiniciar',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO: 'Compartir el perfil por URL solo funcionara si WhatsSpy Publico esta disponible en la internet.',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO2: 'Haga clic en la ficha para copiar el enlace. La generacion de fichas no tiene que ser guardada.',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS: 'Notificaciones',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_ONLINE: 'Proximamente en linea',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_STATUSMSG: 'Cambiar Mensaje de Estado',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PROFPIC: 'Cambiar Foto de Perfil',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PRIV: 'Cambios en Configuracion de Privacidad',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS: 'No Hay Agentes de Notificacion Configurados en',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS_CONFIG: 'config.php',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_MISSING: 'Compruebe config.example.php en caso de que hagan falta estas opciones.',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_SENDING: 'Envio de notificaciones de acciones del usuario a traves de',
    OVERVIEW_AND: 'y',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE: 'Mostrar notificaciones linea de tiempo (Si Esta Abierto)',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE_EXPL: 'Sonido de notificacion utilizado en linea de tiempo para este usuario.',
    OVERVIEW_EDIT_CONTACT_SAVE: 'Guardar Contacto',
    OVERVIEW_EDIT_CONTACT_INACTIVE: 'Conjunto Inactivo',
    OVERVIEW_EDIT_CONTACT_DELETE: 'Borrar Bontacto (!)',
    OVERVIEW_EDIT_CONTACT_DETELE_TITLE: 'Eliminar toda la informacion de este contacto, incluyendo los registros de estado.',
    OVERVIEW_EDIT_CONTACT_INACTIVE_TITLE: 'No realizar el seguimiento del usuario, pero mantener registros de estado / de privacidad de esta persona. Este cambio puede tardar hasta una hora para entrar en vigor en el rastreador.',
    OVERVIEW_GROUPS_H: 'Administrar Grupos',
    OVERVIEW_GROUPS_EXISTING: 'Grupos Existentes',
    OVERVIEW_GROUPS_USERS: 'Usuarios:',
    OVERVIEW_GROUPS_STATSEN: 'Compartir Estadisticas Habilitado',
    OVERVIEW_GROUPS_STATSDIS: 'Compartiendo Deshabilitado*',
    OVERVIEW_GROUPS_NONE: 'No hay Grupos aun por Definir...',
    OVERVIEW_GROUPS_SHARE: '* Puede compartir estadisticas de grupo en la pagina "Estadisticas".',
    OVERVIEW_GROUPS_DELETE: '** Eliminacion del grupo no borrara los usuarios en este grupo.',
    OVERVIEW_GROUPS_DELETEBTN: 'Eliminar Grupo**',
    OVERVIEW_GROUPS_CREATE: 'Crear Grupo',
    OVERVIEW_GROUPS_CREATE_NAME: 'Nombre del Grupo',
    OVERVIEW_GROUPS_CREATEBTN: 'Crear Grupo',
    OVERVIEW_GROUPS_PLACEHOLDER: 'Nombre del Grupo (Necesario)',
    OVERVIEW_GROUPS_CLOSE: 'Cerrar',
    OVERVIEW_PERFORMANCE_H: 'Gestionar el Rendimiento de Interfaz de Usuario',
    OVERVIEW_PERFORMANCE_TIMELINE: 'Tiempo de Cuenta',
    OVERVIEW_PERFORMANCE_TIMELINE_OPTION: 'Mostrar Historia:',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP: 'Este Ajuste Tiene un',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP2: 'Gran',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP3: 'Impacto en el rendimiento cuando se (re) carga una linea de tiempo a los usuarios. Esto afecta la informacion general, comparar y pagina de perfil compartido.',
    OVERVIEW_PERFORMANCE_TRACKER_H: 'Sesiones del Rastreador',
    OVERVIEW_PERFORMANCE_TRACKER_OPTION: 'Vista en Linea de Tiempo',
    OVERVIEW_PERFORMANCE_TRACKER_EXP: 'Este Ajuste Tiene un',
    OVERVIEW_PERFORMANCE_TRACKER_EXP2: 'Minimo',
    OVERVIEW_PERFORMANCE_TRACKER_EXP3: 'Impacto en el Rendimiento Cuando se (re) Carga una Linea de Tiempo a los Usuarios. Esto Afecta Tanto a la Vision General y Comparacion de la Pagina.',
    OVERVIEW_PERFORMANCE_SAVE: 'Guardar Ajustes',
    OVERVIEW_PERFORMANCE_CLOSE: 'Cerrar',
    COMPARE_SELECT: 'Seleccione Candidato(s)',
    COMPARE_ADD_TO_COMPARE: 'Agregar Usuario a la Comparacion',
    COMPARE_ADD: 'Agregar',
    COMPARE_ADD_GROUP_COMPARE: 'Agregar Grupo de Comparacion',
    COMPARE_ADD_NOTICE: 'Cargar Grupos Grandes Puede Causar un Congelamiento Temporal  en el Navegador Debido a la Gran Cantidad de Informacion.',
    COMPARE_CURR_LIST: 'Candidatos Actuales en la Comparacion:',
    COMPARE_CURR_LIST_INFO: 'Ajustes Candidato / Privacidad',
    COMPARE_LASTSEEN: 'Ultima Vista :',
    COMPARE_STATUSMSG: 'Mensajes de Estado :',
    COMPARE_PROFPIC: 'Foto de Perfil :',
    COMPARE_REMOVE: 'Eliminar',
    COMPARE_LOADING: 'Cargando Informacion de Cuenta ...',
    COMPARE_CONTACTS: 'Contactos*',
    COMPARE_EVERYBODY: 'Todos',
    COMPARE_CONTACTS_NOTICE: 'Esta configuracion de privacidad puede ser contactos o nadie. Esto no puede ser detectado.',
    STATS_TOKEN_INFO: 'No tienes permiso para ver este grupo porque el token no es valido.',
    STATS_TOKEN_GROUP: 'Perfil de Grupo Compartido:',
    STATS_TOKEN_GROUP_INFO: 'Se trata de un informe de estadisticas compartida del grupo',
    STATS_TOKEN_GROUP_INFO2: 'Creado por el proveedor de esta instancia WhatsSpy Publico.',
    STATS_NO_INFO: 'No hay suficiente Informacion Disponible ...',
    STATS_LOADING: 'Cargando Informacion ...',
    STATS_FILTER: 'Opciones de Filtro',
    STATS_NOTES: 'Notas',
    STATS_INFO_VALIDITY: 'Toda la informacion en esta pagina no se actualiza. Puede actualizarla haciendo clic en la marca de tiempo gris "Estado".',
    STATS_TOKEN_GEN: 'Generar',
    STATS_TOKEN_RESET: 'Reiniciar',
    STATS_SHARE_INFO: 'Compartir el perfil por URL solo funcionara si WhatsSpy Publico esta disponible en la internet.Haga clic en la Ficha Para Copiar el Enlace.',
    STATS_H: 'Estadisticas de WhatsSpy Publico',
    STATS_TRACKER_STATUS: 'Estado del Rastreador',
    STATS_SESSION: 'Sesiones del Rastreador',
    STATS_FIRST_SESSION: 'Primera Sesion de Seguimiento (Inicio del flujo de Informacion)',
    STATS_DB_CONTENT: 'Contenido Base de Datos',
    STATS_NUMBER_OF_ACC: 'Numero de Cuentas',
    STATS_ACCOUNTS: 'Cuentas',
    STATS_STATUSES: 'Estados',
    STATS_PROFPIC: 'Fotos de Perfil',
    STATS_STSMSG: 'Mensajes de Estado',
    STATS_H_ONLINE: 'Se reunieron Estados en linea / fuera de linea',
    STATS_H_TOTALTIME: 'El tiempo total gastado en WhatsApp por todos los contactos',
    STATS_H_PROFPICSUM: 'Fotos de Perfil Obtenidas',
    STATS_H_STATUSMSGSUM: 'Mensajes de Estado Obtenidos',
    STATS_H_PRIVACY: 'Conciencia de Privacidad',
    STATS_PRIVACY_H: 'Configuracion de Privacidad de Usuarios Rastreados',
    STATS_PRIVACY_TABLE_TH1: 'Opcion de Privacidad',
    STATS_PRIVACY_TABLE_TH2: 'Contactos /o Nadie',
    STATS_PRIVACY_TABLE_TH3: 'Todos',
    STATS_PRIVACY_OPTION1: 'Ultima Vista*',
    STATS_PRIVACY_OPTION2: 'Mensajes de Estado',
    STATS_PRIVACY_OPTION3: 'Fotos de Perfil',
    STATS_PRIVACY_USERS: 'Usuarios',
    STATS_PRIVACY_HISTORY: 'Cambios Privacidad Durante el Seguimiento',
    STATS_PRIVACY_LASTSEEN: 'Cambios de Privacidad en Ultima Vista',
    STATS_PRIVACY_CHANGE: 'Cambios',
    STATS_PRIVACY_PROFPIC: 'Cambios de Privacidad en Foto de Perfil',
    STATS_PRIVACY_STATUSMSG: 'Cambio la Privacidad del Mensaje de Estado',
    STATS_PRIVACY_INFO1: '* La opcion visto por Ultima vez no lo protege contra el Seguimiento en los estados en linea / o Fuera de linea. Mira Esto',
    STATS_PRIVACY_INFO2: 'Articulo',
    STATS_PRIVACY_INFO3: 'Explicando el Problema en Detalle.',
    STATS_PIE_CHART_ONLINE_TIME_H: 'Uso de WhatsApp (Tiempo en linea / Apertura) Comparacion por Usuario',
    STATS_PIE_CHART_TODAY: 'Mostrar Hoy',
    STATS_PIE_CHART_7DAYS: 'Mostrar 7 Dias',
    STATS_PIE_CHART_14DAYS: 'Mostrar 14 Dias',
    STATS_PIE_CHART_ALL: 'Mostar Todo',
    STATS_PIE_CHART_PIE_OPEN_H_ALL: 'Apertura WhatsApp - Todo',
    STATS_PIE_CHART_PIE_OPEN_H_7DAYS: 'Apertura WhatsApp - Ultimos 7 Dias',
    STATS_PIE_CHART_PIE_OPEN_H_14DAYS: 'Apertura WhatsApp  - Ultimos 14 Dias',
    STATS_PIE_CHART_PIE_OPEN_H_TODAY: 'Apertura WhatsApp - Hoy',
    STATS_PIE_CHART_PIE_ONLINE_H_ALL: 'Tiempo de conexion en WhatsApp - Todos',
    STATS_PIE_CHART_PIE_ONLINE_H_7DAYS: 'Tiempo de Conexion en WhatsApp - Ultimos 7 Dias',
    STATS_PIE_CHART_PIE_ONLINE_H_14DAYS: 'Tiempo de conexion en WhatsApp - Ultimos 14 Dias',
    STATS_PIE_CHART_PIE_ONLINE_H_TODAY: 'Tiempo de conexion en WhatsApp - Hoy',
    STATS_PIE_CHART_PIE_INFO: 'Tenga en cuenta que todas las sesiones en linea pueden ser apagadas por 0-4 segundos en WhatsApp, su maquina y su actividad en la red. Esto significa que todos estos datos es el tiempo maximo que gastaron en WhatsApp.',
    STATS_PIE_CHART_BAR_H: 'Uso deWhatsApp (tiempo en linea / apertura) en comparacion por unidad Tiempo',
    STATS_PIE_CHART_BAR_OPEN_H_WEEKDAY: 'WhatsApp Apertura por dia de la Semana',
    STATS_PIE_CHART_BAR_OPEN_H_HOUR: 'WhatsApp Apertura por Hora',
    STATS_PIE_CHART_BAR_SHOWHOUR: 'Mostrar por Hora',
    STATS_PIE_CHART_BAR_SHOWWEEKDAY: 'Mostrar por dia de la Semana',
    STATS_PIE_CHART_BAR_TIME_H_WEEKDAY: 'Tiempo en WhatsApp por dia de la Semana',
    STATS_PIE_CHART_BAR_TIME_H_HOUR: 'Tiempo en WhatsApp por hora',
    STATS_BAR_CHART_TODAY: 'Hoy',
    STATS_BAR_CHART_7DAYS: '7 dias',
    STATS_BAR_CHART_14DAYS: '14 dias',
    STATS_BAR_CHART_ALLTIME: 'Todo el Tiempo',
    STATS_TOP_H1: 'Top',
    STATS_TOP_H2: 'Usuarios Rastreados',
    STATS_TOP_ALL_SHOW: 'Mostrar Todo',
    STATS_TOP_H3: 'La Mayoria de Usuarios activos al dia',
    STATS_TOP_DAYS_AGO: 'Dias Atras',
    STATS_TOP_YESTERDAY: 'Ayer',
    STATS_TOP_TODAY: 'Hoy',
    STATS_TOP_TRACKED_CONTACT: 'Contacto Rastreado',
    STATS_TOP_TIME: 'Tiempo en linea',
    STATS_TOP_OPENED: 'Apertura de WA',
    STATS_TOP_TIMES: 'Veces',
    STATS_TOP_H4: 'Mayoria de Usuarios Activos en Total',
    STATS_TOP_ALL: 'Todo',
    STATS_TOP_DAYS: 'Dias',
    STATS_TOP_HOURS: 'Horas',
    STATS_TYPE_today: 'hoy',
    STATS_TYPE_yesterday: 'ayer',
    STATS_TYPE_2days_ago: '2 dias atras',
    STATS_TYPE_3days_ago: '3 dias atras',
    STATS_TYPE_4days_ago: '4 dias atras',
    STATS_TYPE_alltime: 'todo el tiempo',
    STATS_TYPE_31days: '31 dias',
    STATS_TYPE_14days: '14 dias',
    STATS_TYPE_7days: '7 dias',
    STATS_TYPE_24hours: '24 horas',
    TIMELINE_FILTER: 'Filtros',
    TIMELINE_FILTER_PHONE_PLACEHOLDER: 'Bucar por Numero de Telefono ...',
    TIMELINE_FILTER_NAME_PLACEHOLDER: 'Use el nombre | para filtrar en multiples nombres.',
    TIMELINE_SEARCH_NAME: 'Buscar por Nombre ...',
    TIMELINE_INFO_STATUS: 'El Sistema esta Comprobando Todos los Estados',
    TIMELINE_INFO_FROM: 'De',
    TIMELINE_INFO_CONTACTS: 'Contactos',
    TIMELINE_INFO_CONTINIOUS: 'Continuamente Desde',
    TIMELINE_INFO_LASTSTATUS: 'Contactos que Configuraron "visto por Ultima vez" a no ser Vistos por "nadie" Seran',
    TIMELINE_INFO_LASTSTATUS2: 'Seguidos de Todos Modos',
    TIMELINE_INFO_LIVE: 'A diferencia de la pagina de informacion y comparacion, esta informacion es online.',
    TIMELINE_FILTER_NOTIFY: 'Notificar para cualquier evento (con filtro)',
    TIMELINE_FILTER_TRACKER: 'Mostrar Eventos de Seguimiento',
    TIMELINE_ACTIVITY_H: 'Cronograma de Actividad',
    TIMELINE_STATUS_H: 'Estado de Tiempo',
    TIMELINE_ACTIVITY_TIMESPAN1: 'Actividad linea de Tiempo',
    TIMELINE_ACTIVITY_TIMESPAN2: 'Desde',
    TIMELINE_ACTIVITY_TIMESPAN3: 'Hasta Ahora',
    TIMELINE_ACTIVITY_TRACKERSTART: 'Rastreador en linea',
    TIMELINE_ACTIVITY_TRACKERSTART_STARTED: 'Comenzo en',
    TIMELINE_ACTIVITY_TRACKERSTOP: 'Rastreador Apagado',
    TIMELINE_ACTIVITY_TRACKERSTOP_SESSION: 'Esta Sesion se Mantuvo Desde',
    TIMELINE_ACTIVITY_TRACKERSTOP_TILL: 'Hasta',
    TIMELINE_ACTIVITY_TRACKERSTOP_REASON: 'Causa:',
    TIMELINE_ACTIVITY_TRACKERSTOP_SUPPORT: 'Apoyo a Problemas Comunes',
    TIMELINE_ACTIVITY_STATUSMSG: 'Nuevo Mensaje de Estado Para',
    TIMELINE_ACTIVITY_STATUSMSG_TO: 'Cambiado a',
    TIMELINE_ACTIVITY_PROFPIC: 'Nueva Foto de Perfil Para',
    TIMELINE_ACTIVITY_PROFPIC_TITLE: 'Detectar Cambios de Imagen de Perfil Puede Tardar 0-4 Horas.',
    TIMELINE_ACTIVITY_PRIV: 'Cambio su Configuracion de Privacidad',
    TIMELINE_ACTIVITY_PRIV_OPTION: 'Opcion de Privacidad',
    TIMELINE_ACTIVITY_PRIV_LASTSEEN: 'Ultima Vista',
    TIMELINE_ACTIVITY_PRIV_SETTO: 'Esta Ahora Establecido en',
    TIMELINE_ACTIVITY_PRIV_CONTACTS: 'Contactos*',
    TIMELINE_ACTIVITY_PRIV_EVERYONE: 'Todos',
    TIMELINE_ACTIVITY_PRIV_CONTACTSTITLE: 'Esta configuracion de privacidad puede ser a contactos o nadie. Esto no puede ser detectado.',
    TIMELINE_ACTIVITY_PRIV_PROFPIC: 'Foto de Perfil',
    TIMELINE_ACTIVITY_PRIV_STATUSMSG: 'Mensajes de Estado',
    TIMELINE_ACTIVITY_NOINFO: 'No hay Informacion Disponible ..',
    TIMELINE_ACTIVITY_LOADMORE: 'Click Para Cargar 7 Dias de Entradas Antiguas ..',
    TIMELINE_STATUS_ONLINE: 'Online Desde',
    TIMELINE_STATUS_TILL: 'Hasta',
    TIMELINE_STATUS_NOINFO: 'No hay Informacion Disponible ..',
    TIMELINE_STATUS_NOINFOFILTER: 'No hay estados de usuarios actuales de este filtro ..',
    ABOUT_LICENSE0: 'WhatsSpy publico es una prueba de concepto para demostrar como es rota la configuracion de privacidad en WhatsApp. Con esta herramienta usted puede seguir basicamente cualquier comportamiento solo con el conocimiento de su numero de telefono. Esta herramienta es para Pruebas, solo con fines de Concepto ! Por favor, lea la',
    ABOUT_LICENSE1: 'Licencia',
    ABOUT_LICENSE2: 'Que se Aplica a este PoC.',
    ABOUT_DONATION0: 'Usted Puede Apoyar este Trabajo con una Minima Donacion:',
    ABOUT_DONATION1: 'Bitcoin:',
    ABOUT_DONATION2: 'O Via',
    ABOUT_DONATION3: 'Paypal',
    ABOUT_INFO: 'Informacion General',
    ABOUT_VERSION: 'Ejecutando la Version:',
    ABOUT_UPDATE: 'Esta Disponible.',
    ABOUT_UPTODATE: 'Su Version Esta Actualizada.',
    ABOUT_UPDATE_NOW: 'Actualizar',
    ABOUT_UPDATE_LOG: 'Actualizacion del Registro y Como Actualizar',
    ABOUT_WIKI: 'Pagina Wiki:',
    ABOUT_WIKI_LINK: 'Gitlab Wiki',
    ABOUT_FAQ: 'FAQ:',
    ABOUT_FAQ_LINK: 'Preguntas Frecuentes',
    ABOUT_TROUBLE: 'Solucion de Problemas:',
    ABOUT_TROUBLE_LINK: 'Solucion de Problemas',
    ABOUT_OPTIONS: 'Opciones:',
    ABOUT_OPTIONS_LOGOUT: 'Salir de la Interfaz Web',
    ABOUT_ADVANCED: 'Opciones Avanzadas:',
    ABOUT_ADVANCED_STOP: 'Detener Rastreador',
    ABOUT_ADVANCED_START: 'Iniciar Rastreador',
    ABOUT_ADVANCED_UPDATE: 'Actualizacion Automatica',
    ABOUT_NEWS: 'Literatura / Noticias del Proyecto:',
    ABOUT_AGENTS: 'Agentes de Notificacion',
    ABOUT_AGENTS_NONE1: 'No hay Agentes de Notificacion Configurados en',
    ABOUT_AGENTS_NONE2: 'config.php',
    ABOUT_AGENTS_NONE3: 'Compruebe config.example.php en caso de que haga falta estas opciones.',
    ABOUT_AGENTS_PROPS: 'Propiedades de Notificacion:',
    ABOUT_AGENTS_USER: 'Acciones del Usuario',
    ABOUT_AGENTS_TRACKER: 'Acciones de Seguimiento',
    ABOUT_AGENTS_TO: 'a:',
    ABOUT_AGENTS_RESTART: 'Recuerde que debe reiniciar el rastreador despues de cualquier cambio en su config.php.',
    ABOUT_LANGUAGE: 'Idioma:',
    ABOUT_QA: 'Preguntas y Respuestas',
    CONTROLLER_TIMELINE_1D: '24 Horas (Mejor Rendimiento)',
    CONTROLLER_TIMELINE_7D: '7  Dias',
    CONTROLLER_TIMELINE_14D: '14 Dias',
    CONTROLLER_TIMELINE_31D: '31 Dias (Lento)',
    CONTROLLER_TIMELINE_90D: '90 Dias (Muy Lento)',
    CONTROLLER_CHAR_OPENED: 'Abierto',
    CONTROLLER_CHAR_TIMES: 'Veces',
    CONTROLLER_CHAR_MINUTES: 'Minutos',
    CONTROLLER_COPY: 'Copiar al portapapeles: Ctrl + C, Enter',
    CONTROLLER_WEEKDAY_Sunday: 'Domingo',
    CONTROLLER_WEEKDAY_Monday: 'Lunes',
    CONTROLLER_WEEKDAY_Tuesday: 'Martes',
    CONTROLLER_WEEKDAY_Wednesday: 'Miercoles',
    CONTROLLER_WEEKDAY_Thursday: 'Jueves',
    CONTROLLER_WEEKDAY_Friday: 'Viernes',
    CONTROLLER_WEEKDAY_Saturday: 'Sabado',
    CONTROLLER_NONAME: 'Sin Nombre',
    CONTROLLER_NOTOKEN: 'No Compartido ...',
    CONTROLLER_TRACKER_REASON_NONE: 'No Dado',
    CONTROLLER_TIME_DAY: 'd',
    CONTROLLER_TIME_HOURS: 'h',
    CONTROLLER_TIME_MINUTES: 'min',
    CONTROLLER_TIME_SECONDS: 'seg',
    CONTROLLER_SERVER_NO_RES: 'No se ha Podido Contactar con el Servidor.',
    CONTROLLER_GROUP_NEW: 'Introduzca el Nuevo Nombre Para este Grupo:',
    CONTROLLER_ACCOUNT_DEL: 'Seguro que Quieres Borrar esta Cuenta?',
    CONTROLLER_ACCOUNT_REMOVED: ' Removido!',
    CONTROLLER_ACCOUNT_UPDATED: 'Contacto Actualizado',
    CONTROLLER_ACCOUNT_ADDED: 'Contacto Agregado a WhatsSpy. El Seguimiento comenzara en 5-10 Minutos.',
    CONTROLLER_ACCOUNT_INACTIVE: ' Conjunto Inactivo!',
    CONTROLLER_GROUP_SAVE: 'Guardado Nuevo Nombre de Grupo!',
    CONTROLLER_GROUP_ADD: 'Nuevo Grupo Agregado.',
    CONTROLLER_GROUP_DEL: 'Grupo Removido.',
    CONTROLLER_CONFIG_UPDATE: 'Configuracion Actualizada',
    CONTROLLER_TIME_DAY_FULL: 'Dia',
    CONTROLLER_TIME_WEEK_FULL: 'Semana',
    CONTROLLER_TIME_MONTH_FULL: 'Mes',
    CONTROLLER_TIME_CUSTOM_FULL: 'Personalizado',
    CONTROLLER_TIMELINE_HISTORY: 'Ver Historial:',
    CONTROLLER_TIMELINE_DAYS: 'Dia(s)',
    CONTROLLER_TIMELINE_ONLINE: 'Online',
    CONTROLLER_TIMELINE_DURATION: 'Duracion:',
    CONTROLLER_COMPARISON_ALREADY_IN: ' Esta Listo en la Comparacion!',
    CONTROLLER_NOTIFICATION_ONLINE: ' Esta Ahora Online.',
    CONTROLLER_NOTIFICATION_STATUSMSG: ' Tiene un Nuevo Mensaje de Estado: ',
    CONTROLLER_NOTIFICATION_PROFPIC: ' Ha Subido una Nueva Foto de Perfil.',
    CONTROLLER_NOTIFICATION_PIRV_EVERY: 'Todo',
    CONTROLLER_NOTIFICATION_PRIV_CONTACTS: 'Contactos o Nadie',
    CONTROLLER_NOTIFICATION_PRIV_LASTSEEN: ' Ha Cambiado la Configuracion de Privacidad de Ultima Vista ',
    CONTROLLER_NOTIFICATION_PRIV_PROFPIC: ' Ha Cambiado Su Privacidad En Foto de Perfil ',
    CONTROLLER_NOTIFICATION_PRIV_STATUSMSG: ' Ha Cambiado la Configuracion en su Mensaje de Estado ',
    CONTROLLER_NOTIFICATION_TRACKER_START: 'Rastreador Encendido Para Seguimiento.',
    CONTROLLER_NOTIFICATION_TRACKER_STOP: 'Rastreador ha Detenido el Seguimiento Por Motivo: ',
    CONTROLLER_STAT_TIMES: 'Veces',
    CONTROLLER_CMD0: 'CMD: ',
    CONTROLLER_CMD1: ' resulted in code: ',
    CONTROLLER_CMD2: ' with output: ',
    PRIVACY_STATUS_EVERYONE: 'Todos',
    PRIVACY_STATUS_CONTACTS_OR_NOBODY: 'Contactos o nadie'
    });
    moment.locale('es', {
        months : [
            "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio",
            "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"
        ],
        monthsShort : [
            "Ene", "Feb", "Mar", "Abr", "May", "Jun",
            "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"
        ],
        weekdays : [
            "Domingo", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sabado"
        ],
        weekdaysShort : [
            "Dom", "Lun", "Mar", "Mie", "Jue", "Vie", "Sab"
        ],
        longDateFormat : {
            LT: "h:mm A",
            LTS: "h:mm:ss A",
            L: "MM/DD/YYYY",
            l: "M/D/YYYY",
            LL: "MMMM Do YYYY",
            ll: "MMM D YYYY",
            LLL: "MMMM Do YYYY LT",
            lll: "MMM D YYYY LT",
            LLLL: "dddd, MMMM Do YYYY LT",
            llll: "ddd, MMM D YYYY LT"
        },
        relativeTime : {
            future: "in %s",
            past:   "%s atras",
            s:  "segundos",
            m:  "un minuto",
            mm: "%d minutos",
            h:  "una hora",
            hh: "%d horas",
            d:  "un dia",
            dd: "%d dias",
            M:  "un mes",
            MM: "%d meses",
            y:  "un año",
            yy: "%d añoss"
        }
    });

    $translateProvider.translations('zh-cn', {
    /* PLEASE NOTE that spaces etc. are all of importance here. You also must escape ' (by using \') */
    /* Use your gitlab/real name here to identify your work */
    TRANSLATOR: '',
    MENU_LOGIN: '登录',
    MENU_OVERVIEW: '概况',
    MENU_COMPARE: '对比',
    MENU_TIMELINE: '时间表',
    MENU_STATS: '统计',
    MENU_ABOUT: '关于／帮助',
    MENU_USER: '公开用户',
    MENU_GROUP: '公开组',
    MENU_LOADING: '载入新数据。。。',
    MENU_STATUS: '状态',
    MENU_TRACKER_ONLINE: '跟踪器在线',
    MENU_TRACKER_OFFLINE: '跟踪器不在线',
    MENU_TRACKER_NOAUTH: '末被认证',
    MENU_TRACKER_USERS: '用户',
    MENU_TRACKER_REFRESH: '点击刷新网上应用内已被载入的数据。',
    MENU_POC: '概念验证',
    FOOTER_VERSION: '版',
    FOOTER_V_BEHIND: '后',
    LOGIN_WELCOME: '欢迎！',
    LOGIN_WELCOME_MSG: '欢迎来到WhatsSpy的公共概念验证！开始跟踪前请过目',
    LOGIN_LICENSE: '许可证',
    LOGIN_LOGIN_HEAD: '登录',
    LOGIN_AUTH_NOTIFY: '您还末被认证。请登录以便查看和管理跟踪器。',
    LOGIN_PASS_FIELD: '密码',
    LOGIN_SIGN_IN_BTN: '登录',
    LOGIN_RESET_BTN: '重置',
    LOGIN_PASS_PLACEHOLDER: '密码 。。。',
    TOKEN_INVALID: '令牌无效：',
    OVERVIEW_TOKEN_INVALID: '您不允许查看此用户因为令牌无效或已经失效。',
    OVERVIEW_TOKEN_INFO_STRONG: '共用用户资料：',
    OVERVIEW_TOKEN_INFO: '这个共用用户 资料是由此WhatsSpy公共实例的主机而创建地。时间表内只有上次状态的印象。',
    OVERVIEW_FILTERS: '过滤器',
    OVERVIEW_FILTER_PHONE: '按手机号码搜寻 。。。',
    OVERVIEW_FILTER_NAME_TITLE: '以便筛选多个名请使用名|名。',
    OVERVIEW_FILTER_NAME: '按名搜寻。。。',
    OVERVIEW_INFO_STATUS: '系统正在检查所有状态',
    OVERVIEW_INFO_STATUS_FROM: '从',
    OVERVIEW_INFO_STATUS_CONTACTS: '位联系',
    OVERVIEW_INFO_STATUS_SINCE: '自从',
    OVERVIEW_INFO_PRIV: '凡是把“上次看见”设置为“没人”的联系',
    OVERVIEW_INFO_PRIV_LINK: '照样会被跟踪',
    OVERVIEW_INFO_LIVE: '此页的信息不是实况， 为了刷新此页，您可在"状态"面板内点击灰色时间戳。',
    OVERVIEW_INFO_TIMESPAN: '在时间表旁边, 全部信息都是从开始跟踪此联系起（除非另有说明）。',
    OVERVIEW_INFO_VERIFY: '联系将会在5-10分钟内被验证，',
    OVERVIEW_INFO_RELOAD: '重新载入数据',
    OVERVIEW_INFO_RELOAD_2: '以便再次检查。',
    OVERVIEW_ADD: '添加联系',
    OVERVIEW_IMPORT: '导入Google联系',
    OVERVIEW_MANAGE_GROUPS: '管理群组',
    OVERVIEW_MANAGE_PERF: '绩效选项',
    OVERVIEW_EXPAND: '扩展视图',
    OVERVIEW_COLLAPSE: '折叠视图',
    OVERVIEW_EDIT: '更改',
    OVERVIEW_CONTACT_SINCE: '跟踪自从',
    OVERVIEW_CONTACT_LASTSEEN: '上次看见',
    OVERVIEW_CONTACT_NOTIF: '通知启用',
    OVERVIEW_CONTACT_SHARING: '启用个人资料共享',
    OVERVIEW_NO_INFO: '没有信息可用 。。',
    OVERVIEW_CLICK_LOAD: '点此载入数据',
    OVERVIEW_CLICK_LOAD_TIMELINE: '载入时间表',
    OVERVIEW_CONTACT_H_ANALYTICS: '分析／信息',
    OVERVIEW_CONTACT_ANALYTICS_OVERVIEW: '概况',
    OVERVIEW_CONTACT_ANALYTICS_OPENOVERVIEW: '打开了概况',
    OVERVIEW_CONTACT_ANALYTICS_TIME_OVERVIEW: '时间概况',
    OVERVIEW_CONTACT_ANALYTICS_STATUS: '状态消息',
    OVERVIEW_CONTACT_ANALYTICS_PICS: '个人资料图片',
    OVERVIEW_CONTACT_OPENED_H: '打开WhatsApp客户端',
    OVERVIEW_CONTACT_TABLE_1D: '（24h）今天',
    OVERVIEW_CONTACT_TABLE_7D: '（07d）最近七天',
    OVERVIEW_CONTACT_TABLE_14D: '（14d）最近两周',
    OVERVIEW_CONTACT_TABLE_31D: '（31d）最近一个月',
    OVERVIEW_CONTACT_TABLE_xD: '（---）总时间',
    OVERVIEW_CONTACT_TRACKING_SINCE: '跟踪自从',
    OVERVIEW_CONTACT_TIME_SPENT_WA: '在WhatsApp花的时间',
    OVERVIEW_CONTACT_LOADING_INFO: '载入信息 。。。',
    OVERVIEW_CONTACT_SWITCH_HOUR_VIEW: '按每小时显示',
    OVERVIEW_CONTACT_SWITCH_WEEKDAY_VIEW: '按每周／天显示',
    OVERVIEW_CONTACT_H_OPENING_WA_WEEKDAY: '每周／天打开WhatsApp',
    OVERVIEW_CONTACT_H_OPENING_WA_HOUR: '每小时打开WhatsApp',
    OVERVIEW_CONTACT_H_TIME_WA_WEEKDAY: '每周／天WhatsApp在线时间',
    OVERVIEW_CONTACT_H_TIME_WA_HOUR: '每小时WhatsApp在线时间',
    OVERVIEW_CONTACT_H_PRIV_STATUS: '隐私／在线状态',
    OVERVIEW_CONTACT_PRIV_STATUS: '隐私',
    OVERVIEW_CONTACT_ONLINE_EVENTS: '在线事件',
    OVERVIEW_CONTACT_H_LASTSEEN: '上次看见',
    OVERVIEW_CONTACT_TIMES: '次',
    OVERVIEW_PRIVACY_SETTINGS_PUBLIC: '大家',
    OVERVIEW_PRIVACY_SETTINGS_FRIENDS: '联系*',
    OVERVIEW_PRIVACY_LAST_CHANGE: '更改成',
    OVERVIEW_PRIVACY_LAST_CHANGE_AT: '在',
    OVERVIEW_PRIVACY_H_PROF_PIC: '个人资料图片',
    OVERVIEW_PRIVACY_H_STATUS: '状态消息',
    OVERVIEW_PRIVACY_TRACK_NOTICE: '每两个小时内个人资料图片和状态消息将会受到检查。',
    OVERVIEW_PRIVACY_ASSUMPTION: '假设此用户的联系表里并没有跟踪器的号码。在这情况下\'只有联系\'就会被解读为\'大家\'。',
    OVERVIEW_LOG_FROM: '从',
    OVERVIEW_LOG_TILL: '到',
    OVERVIEW_LOG_NOW: '现在',
    OVERVIEW_NO_ACC: '没有跟踪帐号。。',
    OVERVIEW_ADD_CONTACT_H: '按手机号码添加联系',
    OVERVIEW_ADD_CONTACT_PHONE: '手机号码',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_COUNTRYCODE: '国家代码。。。',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_PHONE: '手机号码。。。',
    OVERVIEW_ADD_CONTACT_NAME: '联系名',
    OVERVIEW_ADD_CONTACT_GROUP: '组',
    OVERVIEW_ADD_CONTACT_NOTICE: '经过成功验证为WhatsApp用户后，新联系并在5-10分钟内添加入跟踪器。之后您可从概况列表里找到联系。',
    OVERVIEW_ADD_CONTACT_ADD: '添加联系',
    OVERVIEW_ADD_CONTACT_CLOSE: '关闭',
    OVERVIEW_EDIT_CONTACT_H: '更改联系名',
    OVERVIEW_EDIT_CONTACT_PHONE: '手机号码',
    OVERVIEW_EDIT_CONTACT_NAME: '联系名',
    OVERVIEW_EDIT_CONTACT_NAME_PLACEHOLDER: '(可选)联系名',
    OVERVIEW_EDIT_CONTACT_GROUPS: '组',
    OVERVIEW_EDIT_CONTACT_PROFILESHARE: '共享个人资料',
    OVERVIEW_EDIT_CONTACT_GENERATE_TOKEN: '创建',
    OVERVIEW_EDIT_CONTACT_RESET_TOKEN: '重置',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO: '共享个人资料统一资源定位符URL仅当WhatsSpy公共从网上可用。',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO2: '点击令牌以便复制链接。产生令牌不必被保存。',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS: '通知',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_ONLINE: '现在上线',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_STATUSMSG: '状态消息被改',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PROFPIC: '个人资料图片被改',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PRIV: '隐私设置被改',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS: '没有通知代理配置在',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS_CONFIG: 'config.php',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_MISSING: '查看config.example.php 如果您缺少这些选项.',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_SENDING: '把用户动作通知发送通过',
    OVERVIEW_AND: '和',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE: '显示时间表通知（若已打开）',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE_EXPL: '正在此用户的时间表里采用通知音响。',
    OVERVIEW_EDIT_CONTACT_SAVE: '保存联系',
    OVERVIEW_EDIT_CONTACT_INACTIVE: '设置为末激活',
    OVERVIEW_EDIT_CONTACT_DELETE: '删除联系（！）',
    OVERVIEW_EDIT_CONTACT_DETELE_TITLE: '删除此联系所有的信息，包括状态记录',
    OVERVIEW_EDIT_CONTACT_INACTIVE_TITLE: '别跟踪用户，但保留他任何的状态/隐私记录。此更改可能需要一个小时才在跟踪器生效。',
    OVERVIEW_GROUPS_H: '管理组',
    OVERVIEW_GROUPS_EXISTING: '现有组',
    OVERVIEW_GROUPS_USERS: '用户：',
    OVERVIEW_GROUPS_STATSEN: '统计分享启用',
    OVERVIEW_GROUPS_STATSDIS: '分享禁用*',
    OVERVIEW_GROUPS_NONE: '目前还没确义组。。。',
    OVERVIEW_GROUPS_SHARE: '* 您可在"统计"页分享组统计。',
    OVERVIEW_GROUPS_DELETE: '** 若组被删除掉，组内的用户并不会同随被删除。',
    OVERVIEW_GROUPS_DELETEBTN: '删除组**',
    OVERVIEW_GROUPS_CREATE: '创建组',
    OVERVIEW_GROUPS_CREATE_NAME: '组名',
    OVERVIEW_GROUPS_CREATEBTN: '创建组',
    OVERVIEW_GROUPS_PLACEHOLDER: '组名 (必需)',
    OVERVIEW_GROUPS_CLOSE: '关闭',
    OVERVIEW_PERFORMANCE_H: '管理用户界面绩效',
    OVERVIEW_PERFORMANCE_TIMELINE: '帐号时间表',
    OVERVIEW_PERFORMANCE_TIMELINE_OPTION: '显示历史：',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP: '此设置拥有',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP2: '大',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP3: '绩效影响当用户时间表被您重新。这会影响到概况，对比页和共用资料页。',
    OVERVIEW_PERFORMANCE_TRACKER_H: '跟踪器会话',
    OVERVIEW_PERFORMANCE_TRACKER_OPTION: '显示在时间表',
    OVERVIEW_PERFORMANCE_TRACKER_EXP: '此设置有个',
    OVERVIEW_PERFORMANCE_TRACKER_EXP2: '小',
    OVERVIEW_PERFORMANCE_TRACKER_EXP3: '性能影响当您重新用户的时间表。这会影响概况页和对比页。',
    OVERVIEW_PERFORMANCE_SAVE: '保存设置',
    OVERVIEW_PERFORMANCE_CLOSE: '关闭',
    COMPARE_SELECT: '选择候选',
    COMPARE_ADD_TO_COMPARE: '把用户加入对比',
    COMPARE_ADD: '加入',
    COMPARE_ADD_GROUP_COMPARE: '把组加入对比',
    COMPARE_ADD_NOTICE: '载入大组可能会造成浏览器展示冻结由于大量的信息.',
    COMPARE_CURR_LIST: '目前在对比里的候选：',
    COMPARE_CURR_LIST_INFO: '候选／隐私设置',
    COMPARE_LASTSEEN: '上次看见：',
    COMPARE_STATUSMSG: '状态消息：',
    COMPARE_PROFPIC: '个人资料图片：',
    COMPARE_REMOVE: '删除',
    COMPARE_LOADING: '载入帐号信息 。。。',
    COMPARE_CONTACTS: '联系*',
    COMPARE_EVERYBODY: '大家',
    COMPARE_CONTACTS_NOTICE: '此隐私设置可能设为联系或没人。此设置不能被检测到。',
    STATS_TOKEN_INFO: '您不允许查看此组因为令牌无效或已经失效。',
    STATS_TOKEN_GROUP: '共用组资料:',
    STATS_TOKEN_GROUP_INFO: '这个是组的共用统计报告',
    STATS_TOKEN_GROUP_INFO2: '通过此Whatsspy公共实例的主机所创建地。',
    STATS_NO_INFO: '可用信息不足够。。。',
    STATS_LOADING: '载入信息。。。',
    STATS_FILTER: '过滤选项',
    STATS_NOTES: '备注',
    STATS_INFO_VALIDITY: '此页所有的信息不会刷新。 您可在"状态"里点击灰色时间戳以便刷新。',
    STATS_TOKEN_GEN: '创建',
    STATS_TOKEN_RESET: '重置',
    STATS_SHARE_INFO: '分享此统计组页统一资源定位符URL的功能仅当Whatsspy公共在网上可用。请点击令牌以便复制链接。',
    STATS_H: 'WhatsSpy公共统计',
    STATS_TRACKER_STATUS: '跟踪器状态',
    STATS_SESSION: '跟踪器会话',
    STATS_FIRST_SESSION: '第一跟踪器会话（信息流程的开始）',
    STATS_DB_CONTENT: '数据库内容',
    STATS_NUMBER_OF_ACC: '帐号数目',
    STATS_ACCOUNTS: '帐号',
    STATS_STATUSES: '状态',
    STATS_PROFPIC: '个人资料图片',
    STATS_STSMSG: '状态消息',
    STATS_H_ONLINE: '在线／离线状态采集',
    STATS_H_TOTALTIME: '所有联系在WhatsApp花费的总共时间',
    STATS_H_PROFPICSUM: '被收集的个人资料图片',
    STATS_H_STATUSMSGSUM: '状态消息采集',
    STATS_H_PRIVACY: '隐私意识',
    STATS_PRIVACY_H: '被跟踪用户的隐私设置',
    STATS_PRIVACY_TABLE_TH1: '隐私选项',
    STATS_PRIVACY_TABLE_TH2: '联系／没人',
    STATS_PRIVACY_TABLE_TH3: '大家',
    STATS_PRIVACY_OPTION1: '上次看见＊',
    STATS_PRIVACY_OPTION2: '状态消息',
    STATS_PRIVACY_OPTION3: '个人资料图片',
    STATS_PRIVACY_USERS: '用户',
    STATS_PRIVACY_HISTORY: '当跟踪时隐私的更改',
    STATS_PRIVACY_LASTSEEN: '上次看见隐私的更改',
    STATS_PRIVACY_CHANGE: '更改',
    STATS_PRIVACY_PROFPIC: '个人资料图片隐私的更改',
    STATS_PRIVACY_STATUSMSG: '状态消息隐私的更改',
    STATS_PRIVACY_INFO1: '* 上次看见设置不会保护您的上线／离线状态免受到跟踪。 请查看这篇',
    STATS_PRIVACY_INFO2: '文章',
    STATS_PRIVACY_INFO3: '详细得解释此问题。',
    STATS_PIE_CHART_ONLINE_TIME_H: '按各人比较WhatsApp用量（在线时间／打开）',
    STATS_PIE_CHART_TODAY: '显示今天',
    STATS_PIE_CHART_7DAYS: '显示7天',
    STATS_PIE_CHART_14DAYS: '显示14天',
    STATS_PIE_CHART_ALL: '显示全部',
    STATS_PIE_CHART_PIE_OPEN_H_ALL: '打开WhatsApp－全部',
    STATS_PIE_CHART_PIE_OPEN_H_7DAYS: '打开WhatsApp－最近7天',
    STATS_PIE_CHART_PIE_OPEN_H_14DAYS: '打开WhatsApp－最近14天',
    STATS_PIE_CHART_PIE_OPEN_H_TODAY: '打开WhatsApp－今天',
    STATS_PIE_CHART_PIE_ONLINE_H_ALL: 'WhatsApp在线时间－全部',
    STATS_PIE_CHART_PIE_ONLINE_H_7DAYS: 'WhatsApp在线时间－最近7天',
    STATS_PIE_CHART_PIE_ONLINE_H_14DAYS: 'WhatsApp在线时间－最近14天',
    STATS_PIE_CHART_PIE_ONLINE_H_TODAY: 'WhatsApp在线时间－今天',
    STATS_PIE_CHART_PIE_INFO: '请注意每份在线会话可能会有0-4秒不准确，取决于WhatsApp，您的机器状况以及您的网上活动。这表示全部数据就是他们在WhatsApp花上的最长时间。',
    STATS_PIE_CHART_BAR_H: 'WhatsApp用量（在线时间／打开）时间计算对比',
    STATS_PIE_CHART_BAR_OPEN_H_WEEKDAY: '每周／天打开WhatsApp',
    STATS_PIE_CHART_BAR_OPEN_H_HOUR: '每小时打开WhatsApp',
    STATS_PIE_CHART_BAR_SHOWHOUR: '按每小时显示',
    STATS_PIE_CHART_BAR_SHOWWEEKDAY: '按每周／天显示',
    STATS_PIE_CHART_BAR_TIME_H_WEEKDAY: '每周／天在WhatsApp花的时间',
    STATS_PIE_CHART_BAR_TIME_H_HOUR: '每小时在WhatsApp花的时间',
    STATS_BAR_CHART_TODAY: '今天',
    STATS_BAR_CHART_7DAYS: '7天',
    STATS_BAR_CHART_14DAYS: '14天',
    STATS_BAR_CHART_ALLTIME: '全部时间',
    STATS_TOP_H1: '最高',
    STATS_TOP_H2: '被跟踪的用户',
    STATS_TOP_ALL_SHOW: '显示全部',
    STATS_TOP_H3: '每天最多活动的用户',
    STATS_TOP_DAYS_AGO: '天前',
    STATS_TOP_YESTERDAY: '昨天',
    STATS_TOP_TODAY: '今天',
    STATS_TOP_TRACKED_CONTACT: '被跟踪的联系',
    STATS_TOP_TIME: '在线时间',
    STATS_TOP_OPENED: '打开 WA',
    STATS_TOP_TIMES: '次',
    STATS_TOP_H4: '总计最多活动的用户',
    STATS_TOP_ALL: '全部',
    STATS_TOP_DAYS: '天',
    STATS_TOP_HOURS: '小时',
    STATS_TYPE_today: '今天',
    STATS_TYPE_yesterday: '昨天',
    STATS_TYPE_2days_ago: '两天前',
    STATS_TYPE_3days_ago: '三天前',
    STATS_TYPE_4days_ago: '四天前',
    STATS_TYPE_alltime: '全部时间',
    STATS_TYPE_31days: '31天',
    STATS_TYPE_14days: '14天',
    STATS_TYPE_7days: '7天',
    STATS_TYPE_24hours: '24小时',
    TIMELINE_FILTER: '过滤器',
    TIMELINE_FILTER_PHONE_PLACEHOLDER: '按手机号码搜索 。。。',
    TIMELINE_FILTER_NAME_PLACEHOLDER: '以便筛选多个名请使用名|名。',
    TIMELINE_SEARCH_NAME: '按名搜索 。。。',
    TIMELINE_INFO_STATUS: '系统正在检查所有状态',
    TIMELINE_INFO_FROM: '从',
    TIMELINE_INFO_CONTACTS: '联系',
    TIMELINE_INFO_CONTINIOUS: '连续从',
    TIMELINE_INFO_LASTSTATUS: '把“上次看见”设置为“没人”的联系将会',
    TIMELINE_INFO_LASTSTATUS2: '照样被跟踪',
    TIMELINE_INFO_LIVE: '此信息是实时地， 不象概况和对比页。',
    TIMELINE_FILTER_NOTIFY: '通知任何事件（使用过滤器）',
    TIMELINE_FILTER_TRACKER: '显示跟踪器事件',
    TIMELINE_ACTIVITY_H: '活动时间表',
    TIMELINE_STATUS_H: '状态时间表',
    TIMELINE_ACTIVITY_TIMESPAN1: '活动时间表',
    TIMELINE_ACTIVITY_TIMESPAN2: '从',
    TIMELINE_ACTIVITY_TIMESPAN3: '直到现在',
    TIMELINE_ACTIVITY_TRACKERSTART: '跟踪器现在在线',
    TIMELINE_ACTIVITY_TRACKERSTART_STARTED: '开始自从',
    TIMELINE_ACTIVITY_TRACKERSTOP: '跟踪器现在不在线',
    TIMELINE_ACTIVITY_TRACKERSTOP_SESSION: '此会话 维持从',
    TIMELINE_ACTIVITY_TRACKERSTOP_TILL: '直到',
    TIMELINE_ACTIVITY_TRACKERSTOP_REASON: '原因：',
    TIMELINE_ACTIVITY_TRACKERSTOP_SUPPORT: '常见问题支持',
    TIMELINE_ACTIVITY_STATUSMSG: '新状态消息',
    TIMELINE_ACTIVITY_STATUSMSG_TO: '更改成',
    TIMELINE_ACTIVITY_PROFPIC: '新个人资料图片',
    TIMELINE_ACTIVITY_PROFPIC_TITLE: '检测个人资料图片的更改可能需要0－4小时.',
    TIMELINE_ACTIVITY_PRIV: '更改了隐私设置',
    TIMELINE_ACTIVITY_PRIV_OPTION: '隐私选项',
    TIMELINE_ACTIVITY_PRIV_LASTSEEN: '上次看见',
    TIMELINE_ACTIVITY_PRIV_SETTO: '现在设置为',
    TIMELINE_ACTIVITY_PRIV_CONTACTS: '联系＊',
    TIMELINE_ACTIVITY_PRIV_EVERYONE: '大家',
    TIMELINE_ACTIVITY_PRIV_CONTACTSTITLE: '此隐私设置可能设为联系或没人。这是无法被检测到地。',
    TIMELINE_ACTIVITY_PRIV_PROFPIC: '个人资料图片',
    TIMELINE_ACTIVITY_PRIV_STATUSMSG: '状态消息',
    TIMELINE_ACTIVITY_NOINFO: '没有可用的信息 。。',
    TIMELINE_ACTIVITY_LOADMORE: '点此载入多7天的旧项 。。',
    TIMELINE_STATUS_ONLINE: '在线从',
    TIMELINE_STATUS_TILL: '直到',
    TIMELINE_STATUS_NOINFO: '没有可用的信息 。。',
    TIMELINE_STATUS_NOINFOFILTER: ' 此过滤器没有可用的用户状态。。',
    ABOUT_LICENSE0: 'WhatsSpy Public是个概念验证（Proof of Concept）来显示WhatsApp隐私设置的缺点。基本上采用了此工具您只许知道手机号码必能跟踪任何人的行动。此工具用意限制为概念验证！请参考这份',
    ABOUT_LICENSE1: '许可证',
    ABOUT_LICENSE2: '使用于此概念验证。',
    ABOUT_DONATION0: '您可通过一个小捐赠协助支持这项工作:',
    ABOUT_DONATION1: 'Bitcoin：',
    ABOUT_DONATION2: '或经过',
    ABOUT_DONATION3: 'Paypal',
    ABOUT_INFO: '基本信息',
    ABOUT_VERSION: '运行版本：',
    ABOUT_UPDATE: '可用。',
    ABOUT_UPTODATE: '您的版本是最新地。',
    ABOUT_UPDATE_NOW: '更新',
    ABOUT_UPDATE_LOG: '更新记录和更新方法',
    ABOUT_WIKI: 'Wiki主页：',
    ABOUT_WIKI_LINK: 'Gitlab Wiki',
    ABOUT_FAQ: '常问问题:',
    ABOUT_FAQ_LINK: '常问问题',
    ABOUT_TROUBLE: '故障排查：',
    ABOUT_TROUBLE_LINK: '故障排查',
    ABOUT_OPTIONS: '选项：',
    ABOUT_OPTIONS_LOGOUT: '登出WebUI',
    ABOUT_LANGUAGE: '客户端语言：',
    ABOUT_ADVANCED: '高级选项：',
    ABOUT_ADVANCED_STOP: '停止跟踪器',
    ABOUT_ADVANCED_START: '启动跟踪器',
    ABOUT_ADVANCED_UPDATE: '自动更新',
    ABOUT_NEWS: '项目文档/消息：',
    ABOUT_AGENTS: '通知代理',
    ABOUT_AGENTS_NONE1: '没有通知代理配置在',
    ABOUT_AGENTS_NONE2: 'config.php',
    ABOUT_AGENTS_NONE3: '查看config.example.php假若这些选项不存在.',
    ABOUT_AGENTS_PROPS: '通知属性:',
    ABOUT_AGENTS_USER: '用户动作',
    ABOUT_AGENTS_TRACKER: '跟踪器动作',
    ABOUT_AGENTS_TO: '到：',
    ABOUT_AGENTS_RESTART: '在config.php里做了更改之后请记住重新启动跟踪器。',
    ABOUT_QA: '问题与解答',
    CONTROLLER_TIMELINE_1D: '24 小时 (最佳性能)',
    CONTROLLER_TIMELINE_7D: '7  天',
    CONTROLLER_TIMELINE_14D: '14 天',
    CONTROLLER_TIMELINE_31D: '31 天（慢）',
    CONTROLLER_TIMELINE_90D: '90 天（超慢）',
    CONTROLLER_CHAR_OPENED: '打开',
    CONTROLLER_CHAR_TIMES: '次',
    CONTROLLER_CHAR_MINUTES: '分钟',
    CONTROLLER_COPY: '复制到剪贴板： Ctrl＋C，Enter',
    CONTROLLER_WEEKDAY_Sunday: '星期日',
    CONTROLLER_WEEKDAY_Monday: '星期一',
    CONTROLLER_WEEKDAY_Tuesday: '星期二',
    CONTROLLER_WEEKDAY_Wednesday: '星期三',
    CONTROLLER_WEEKDAY_Thursday: '星期四',
    CONTROLLER_WEEKDAY_Friday: '星期五',
    CONTROLLER_WEEKDAY_Saturday: '星期六',
    CONTROLLER_NONAME: '无名',
    CONTROLLER_NOTOKEN: '没有分享 。。。',
    CONTROLLER_TRACKER_REASON_NONE: '没有给出',
    CONTROLLER_TIME_DAY: '天',
    CONTROLLER_TIME_HOURS: '时',
    CONTROLLER_TIME_MINUTES: '分',
    CONTROLLER_TIME_SECONDS: '秒',
    CONTROLLER_SERVER_NO_RES: '无法与服务器联系',
    CONTROLLER_GROUP_NEW: '请输入此组的新名：',
    CONTROLLER_ACCOUNT_DEL: '确定删除这个帐号？',
    CONTROLLER_ACCOUNT_REMOVED: ' 删除了！',
    CONTROLLER_ACCOUNT_UPDATED: '联系已更新',
    CONTROLLER_ACCOUNT_ADDED: '联系已添加入Whatsspy。5-10分钟内就会开始跟踪。',
    CONTROLLER_ACCOUNT_INACTIVE: ' 设置为未激活！',
    CONTROLLER_GROUP_SAVE: '组的新名已保存！',
    CONTROLLER_GROUP_ADD: '新租已被添加。',
    CONTROLLER_GROUP_DEL: '租已被删除。',
    CONTROLLER_CONFIG_UPDATE: '配置已更新',
    CONTROLLER_TIME_DAY_FULL: '日',
    CONTROLLER_TIME_WEEK_FULL: '周',
    CONTROLLER_TIME_MONTH_FULL: '月',
    CONTROLLER_TIME_CUSTOM_FULL: '自定',
    CONTROLLER_TIMELINE_HISTORY: '历史视图：',
    CONTROLLER_TIMELINE_DAYS: '天',
    CONTROLLER_TIMELINE_ONLINE: '在线',
    CONTROLLER_TIMELINE_DURATION: '持续时间：',
    CONTROLLER_COMPARISON_ALREADY_IN: ' 已经在对比内！',
    CONTROLLER_NOTIFICATION_ONLINE: ' 现在在线。',
    CONTROLLER_NOTIFICATION_STATUSMSG: ' 有新的状态消息： ',
    CONTROLLER_NOTIFICATION_PROFPIC: ' 有新的 个人资料图片。',
    CONTROLLER_NOTIFICATION_PIRV_EVERY: '大家',
    CONTROLLER_NOTIFICATION_PRIV_CONTACTS: '联系或没人',
    CONTROLLER_NOTIFICATION_PRIV_LASTSEEN: ' 把他的上次看见隐私设置改为 ',
    CONTROLLER_NOTIFICATION_PRIV_PROFPIC: ' 把他的个人资料图片隐私设置改为 ',
    CONTROLLER_NOTIFICATION_PRIV_STATUSMSG: ' 把他的状态消息的隐私设置改为 ',
    CONTROLLER_NOTIFICATION_TRACKER_START: '跟踪器已开始跟踪。',
    CONTROLLER_NOTIFICATION_TRACKER_STOP: '跟踪器已停止跟踪与此原因： ',
    CONTROLLER_STAT_TIMES: '次',
    CONTROLLER_CMD0: '命令： ',
    CONTROLLER_CMD1: ' 导致与代码: ',
    CONTROLLER_CMD2: ' 与输出： ',
    PRIVACY_STATUS_EVERYONE: '大家',
    PRIVACY_STATUS_CONTACTS_OR_NOBODY: '联系或没人'
    });
    moment.locale('zh-cn', {
        months : [
            "一月", "二月", "三月", "四月", "五月", "六月", "七月",
            "八月", "九月", "十月", "十一月", "十二月"
        ],
        monthsShort : [
            "一月", "二月", "三月", "四月", "五月", "六月",
            "七月", "八月", "九月", "十月", "十一月", "十二月"
        ],
        weekdays : [
            "星期日", "星期一", "星期二", "新期三", "星期四", "新期五", "新期六"
        ],
        weekdaysShort : [
            "星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"
        ],
        longDateFormat : {
            LT: "h:mm A",
            LTS: "h:mm:ss A",
            L: "MM/DD/YYYY",
            l: "M/D/YYYY",
            LL: "MMMM Do YYYY",
            ll: "MMM D YYYY",
            LLL: "MMMM Do YYYY LT",
            lll: "MMM D YYYY LT",
            LLLL: "dddd, MMMM Do YYYY LT",
            llll: "ddd, MMM D YYYY LT"
        },
        relativeTime : {
            future: "在 %s",
            past:   "%s 前",
            s:  "秒",
            m:  "一分种",
            mm: "%d 分种",
            h:  "一小时",
            hh: "%d 小时",
            d:  "一天",
            dd: "%d 天",
            M:  "一个月",
            MM: "%d 月",
            y:  "一年",
            yy: "%d 年"
        }
    });

    $translateProvider.translations('id', {
    /* PLEASE NOTE that spaces etc. are all of importance here. You also must escape ' (by using \') */
    /* Use your gitlab/real name here to identify your work */
    TRANSLATOR: '',
    MENU_LOGIN: 'Login',
    MENU_OVERVIEW: 'Ringkasan',
    MENU_COMPARE: 'Membandingkan',
    MENU_TIMELINE: 'Garis waktu',
    MENU_STATS: 'Statistik',
    MENU_ABOUT: 'Tentang / Tolongan',
    MENU_USER: 'Pengguna publik',
    MENU_GROUP: 'Kelompok publik',
    MENU_LOADING: 'Memuat data baru ...',
    MENU_STATUS: 'status',
    MENU_TRACKER_ONLINE: 'Pelacak online',
    MENU_TRACKER_OFFLINE: 'Pelacak offline',
    MENU_TRACKER_NOAUTH: 'belum diotentikasi',
    MENU_TRACKER_USERS: 'pengguna',
    MENU_TRACKER_REFRESH: 'Klik untuk mengyergarkan data yang dimuatkan dalam web-app.',
    MENU_POC: 'Bukti Konsep',
    FOOTER_VERSION: 'Versi',
    FOOTER_V_BEHIND: 'Di belakang',
    LOGIN_WELCOME: 'Selamat Datang!',
    LOGIN_WELCOME_MSG: 'Selamat Datang ke WhatsSpy Public PoC! Sebelum Anda memulai pelecakan silahkan baca',
    LOGIN_LICENSE: 'lisensi',
    LOGIN_LOGIN_HEAD: 'Masuk',
    LOGIN_AUTH_NOTIFY: 'Sepertinya Anda belum diotentikasi. Silahkan login untuk melihat dan mengatur pelacak.',
    LOGIN_PASS_FIELD: 'Kata sandi',
    LOGIN_SIGN_IN_BTN: 'Masuk',
    LOGIN_RESET_BTN: 'Reset',
    LOGIN_PASS_PLACEHOLDER: 'kata sandi ...',
    TOKEN_INVALID: 'Token tidak valid:',
    OVERVIEW_TOKEN_INVALID: 'Anda tidak diizinkan untuk melihat pengguna ini karena token adalah atau menjadi tidak valid.',
    OVERVIEW_TOKEN_INFO_STRONG: 'Profil pengguna berbagi:',
    OVERVIEW_TOKEN_INFO: 'Ini adalah satu profil pengguna berbagi yang dibuat oleh hoster contoh WhatsSpy Publik. Garis waktu hanya berisi ringkasan dari status terakhir.',
    OVERVIEW_FILTERS: 'Saringan',
    OVERVIEW_FILTER_PHONE: 'Mencari dengan nomor telepon ...',
    OVERVIEW_FILTER_NAME_TITLE: 'Gunakan nama|nama untuk menyaring pada berberapa nama.',
    OVERVIEW_FILTER_NAME: 'Mencari dengan nama ...',
    OVERVIEW_INFO_STATUS: 'Sistem sedang memeriksa semua status',
    OVERVIEW_INFO_STATUS_FROM: 'dari',
    OVERVIEW_INFO_STATUS_CONTACTS: 'kontak',
    OVERVIEW_INFO_STATUS_SINCE: 'sejak',
    OVERVIEW_INFO_PRIV: 'kontak dengan "terakhir terlihat" yang diatur ke "tanpa orang" akan',
    OVERVIEW_INFO_PRIV_LINK: 'bagaimanapun dilacak',
    OVERVIEW_INFO_LIVE: 'Informasi pada halaman ini tidak langsung, Anda dapat klik penanda waktu abu-abu di panel "status" untuk menyegarkan halaman ini.',
    OVERVIEW_INFO_TIMESPAN: 'Di samping garis waktu, semua informasi adalah dari sejak Anda mulai melacak kontak ini (kecuali dinyatakan sebaliknya).',
    OVERVIEW_INFO_VERIFY: 'kontak-kontak akan diverifikasi dalam 5-10 menit,',
    OVERVIEW_INFO_RELOAD: 'memuati data lagi',
    OVERVIEW_INFO_RELOAD_2: 'sehingga memeriksa lagi.',
    OVERVIEW_ADD: 'Tambahkan Kontak',
    OVERVIEW_IMPORT: 'Mengimpor Kontak Google',
    OVERVIEW_MANAGE_GROUPS: 'Mengelola kelompok-kelompok',
    OVERVIEW_MANAGE_PERF: 'Pilihan Kinerja',
    OVERVIEW_EXPAND: 'Memperluas pandangan view',
    OVERVIEW_COLLAPSE: 'Runtuh pandangan',
    OVERVIEW_EDIT: 'Mengedit',
    OVERVIEW_CONTACT_SINCE: 'pelecakan sejak',
    OVERVIEW_CONTACT_LASTSEEN: 'terakhir terlihat',
    OVERVIEW_CONTACT_NOTIF: 'pemberitahuan diaktifkan',
    OVERVIEW_CONTACT_SHARING: 'berbagi profil diaktifkan',
    OVERVIEW_NO_INFO: 'Tidak ada informasi yang tersedia ..',
    OVERVIEW_CLICK_LOAD: 'Klik untuk memuat data',
    OVERVIEW_CLICK_LOAD_TIMELINE: 'Memuat timeline',
    OVERVIEW_CONTACT_H_ANALYTICS: 'Analisis / Informasi',
    OVERVIEW_CONTACT_ANALYTICS_OVERVIEW: 'Ringkasan',
    OVERVIEW_CONTACT_ANALYTICS_OPENOVERVIEW: 'Ringkasan dibuka',
    OVERVIEW_CONTACT_ANALYTICS_TIME_OVERVIEW: 'Ringkasan waktu',
    OVERVIEW_CONTACT_ANALYTICS_STATUS: 'Pesan-pesan Status',
    OVERVIEW_CONTACT_ANALYTICS_PICS: 'Gambar Profil',
    OVERVIEW_CONTACT_OPENED_H: 'Membuka klien WhatsApp',
    OVERVIEW_CONTACT_TABLE_1D: '(24j) hari ini',
    OVERVIEW_CONTACT_TABLE_7D: '(07h) 7 jam lalu',
    OVERVIEW_CONTACT_TABLE_14D: '(14h) dua minggu lalu',
    OVERVIEW_CONTACT_TABLE_31D: '(31h) bulan lalu',
    OVERVIEW_CONTACT_TABLE_xD: '(---) semua waktu',
    OVERVIEW_CONTACT_TRACKING_SINCE: 'Pelacakan sejak',
    OVERVIEW_CONTACT_TIME_SPENT_WA: 'Waktu yang dihabiskan di WhatsApp',
    OVERVIEW_CONTACT_LOADING_INFO: 'Memuat informasi ...',
    OVERVIEW_CONTACT_SWITCH_HOUR_VIEW: 'Tampilkan per jam',
    OVERVIEW_CONTACT_SWITCH_WEEKDAY_VIEW: 'Tampilkan per hari kerja',
    OVERVIEW_CONTACT_H_OPENING_WA_WEEKDAY: 'Membuka WhatsApp per hari kerja',
    OVERVIEW_CONTACT_H_OPENING_WA_HOUR: 'Membuka WhatsApp per jam',
    OVERVIEW_CONTACT_H_TIME_WA_WEEKDAY: 'Waktu pada WhatsApp per minggu hari',
    OVERVIEW_CONTACT_H_TIME_WA_HOUR: 'Waktu pada WhatsApp per jam',
    OVERVIEW_CONTACT_H_PRIV_STATUS: 'Status Privasi / Online',
    OVERVIEW_CONTACT_PRIV_STATUS: 'Privasi',
    OVERVIEW_CONTACT_ONLINE_EVENTS: 'Perisitiwa Online',
    OVERVIEW_CONTACT_H_LASTSEEN: 'Terakhir terlihat',
    OVERVIEW_CONTACT_TIMES: 'kali',
    OVERVIEW_PRIVACY_SETTINGS_PUBLIC: 'semua orang',
    OVERVIEW_PRIVACY_SETTINGS_FRIENDS: 'kontak*',
    OVERVIEW_PRIVACY_LAST_CHANGE: 'merubah ke',
    OVERVIEW_PRIVACY_LAST_CHANGE_AT: 'pada',
    OVERVIEW_PRIVACY_H_PROF_PIC: 'Gambar profil',
    OVERVIEW_PRIVACY_H_STATUS: 'Pesan-pesan status',
    OVERVIEW_PRIVACY_TRACK_NOTICE: 'Gambar profil dan pesan status diperiksa setiap 2 jam.',
    OVERVIEW_PRIVACY_ASSUMPTION: 'Dengan asumsi pengguna ini tidak memliki nomor pelacak dalam daftar kontak. Jika hal ini terjadi \'hanya kontak\' akan ditafsirkan \'semua orang\' dalam pandangan ini.',
    OVERVIEW_LOG_FROM: 'sejak',
    OVERVIEW_LOG_TILL: 'sampai',
    OVERVIEW_LOG_NOW: 'sekarang',
    OVERVIEW_NO_ACC: 'Tidak ada pelacakan akun ..',
    OVERVIEW_ADD_CONTACT_H: 'Tambahkan kontak dengan nomor telepon',
    OVERVIEW_ADD_CONTACT_PHONE: 'Nomor telepon',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_COUNTRYCODE: 'kode negara ...',
    OVERVIEW_ADD_CONTACT_PLACEHOLDER_PHONE: 'nomor telepon ...',
    OVERVIEW_ADD_CONTACT_NAME: 'Nama kontak',
    OVERVIEW_ADD_CONTACT_GROUP: 'Kelompok-kelompok',
    OVERVIEW_ADD_CONTACT_NOTICE: 'Kontak baru akan diverifikasi sebagai pengguna WhatsApp dan ditambahkan ke pelacak dalam 5-10 menit. Setelah ini Anda dapat menemukan kontak dalam daftar ringkasan.',
    OVERVIEW_ADD_CONTACT_ADD: 'Tambahkan kontak',
    OVERVIEW_ADD_CONTACT_CLOSE: 'Tutup',
    OVERVIEW_EDIT_CONTACT_H: 'Mengedit nama kontak',
    OVERVIEW_EDIT_CONTACT_PHONE: 'Nomor telepon',
    OVERVIEW_EDIT_CONTACT_NAME: 'Nama kontak',
    OVERVIEW_EDIT_CONTACT_NAME_PLACEHOLDER: '(opsional) nama kontak',
    OVERVIEW_EDIT_CONTACT_GROUPS: 'Kelompok-kelompok',
    OVERVIEW_EDIT_CONTACT_PROFILESHARE: 'Berbagi profil',
    OVERVIEW_EDIT_CONTACT_GENERATE_TOKEN: 'Buat',
    OVERVIEW_EDIT_CONTACT_RESET_TOKEN: 'Reset',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO: 'Berbagi URL profile akan berfungsi jika WhatsSpy Publik tersedia dari internet.',
    OVERVIEW_EDIT_CONTACT_TOKEN_INFO2: 'Klik pada token untuk menyalin link. Pembuatan token tidak harus disimpan',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS: 'Pemberitahuan',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_ONLINE: 'Mendatang online',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_STATUSMSG: 'Perubahan pesan status',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PROFPIC: 'Perubahan gambar profil',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_PRIV: 'Perubahan pengaturan privasi',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS: 'Belum ada agen pemberitahuan dikonfigurasi dalam',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_AGENTS_CONFIG: 'config.php',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_MISSING: 'Memeriksa config.example.php jika kehilangan pilihan ini.',
    OVERVIEW_EDIT_CONTACT_NOTIFICATIONS_SENDING: 'Mengirim pemberitahuan untuk tindakan pengguna melalui',
    OVERVIEW_AND: 'dan',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE: 'Tampilkan timeline pemberitahuan (jika terbuka)',
    OVERVIEW_EDIT_CONTACT_SHOW_TIMELINE_EXPL: 'Suara pemberitahuan digunakan dalam timeline untuk pengguna ini.',
    OVERVIEW_EDIT_CONTACT_SAVE: 'Simpan kontak',
    OVERVIEW_EDIT_CONTACT_INACTIVE: 'Mengatur non-aktif',
    OVERVIEW_EDIT_CONTACT_DELETE: 'Hapus kontak (!)',
    OVERVIEW_EDIT_CONTACT_DETELE_TITLE: 'Hapus semua informasi of this contact, termasuk catatan status.',
    OVERVIEW_EDIT_CONTACT_INACTIVE_TITLE: 'Jangan melacak pengguna, tetapi menjaga setiap catatan status/privasi dari orang ini. Perubahan ini bisa memakan waktu hingga satu jam untuk berlaku di pelacak.',
    OVERVIEW_GROUPS_H: 'Mengelola Kelompok-kelompok',
    OVERVIEW_GROUPS_EXISTING: 'kelompok yang ada',
    OVERVIEW_GROUPS_USERS: 'Pengguna:',
    OVERVIEW_GROUPS_STATSEN: 'Statistik berbagi diaktifkan',
    OVERVIEW_GROUPS_STATSDIS: 'Berbagi dinonaktifkan*',
    OVERVIEW_GROUPS_NONE: 'Belum ada kelompok didefinisikan...',
    OVERVIEW_GROUPS_SHARE: '* Anda dapat berbagi statistik kelompok di halaman "Statistik".',
    OVERVIEW_GROUPS_DELETE: '** Menghapus kelompok tidak akan menghapus pengguna dalam kelompok ini.',
    OVERVIEW_GROUPS_DELETEBTN: 'Menghapus kelompok**',
    OVERVIEW_GROUPS_CREATE: 'Membuat kelompok',
    OVERVIEW_GROUPS_CREATE_NAME: 'Nama Kelompok',
    OVERVIEW_GROUPS_CREATEBTN: 'Membuat kelompok',
    OVERVIEW_GROUPS_PLACEHOLDER: 'Nama kelopmok (diperlukan)',
    OVERVIEW_GROUPS_CLOSE: 'Tutup',
    OVERVIEW_PERFORMANCE_H: 'Mengelola Kinerja Antarmuka Pengguna',
    OVERVIEW_PERFORMANCE_TIMELINE: 'Garis waktu akun',
    OVERVIEW_PERFORMANCE_TIMELINE_OPTION: 'Tampilkan sejarah:',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP: 'Pengaturan ini memiliki dampak kinerja',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP2: 'besar',
    OVERVIEW_PERFORMANCE_TIMELINE_EXP3: 'ketika Anda memuat (kembali) garis waktu pengguna. Hal ini mempengaruhi ringkasan, membandingkan dan halaman profil bersama.',
    OVERVIEW_PERFORMANCE_TRACKER_H: 'Sesi Pelacak',
    OVERVIEW_PERFORMANCE_TRACKER_OPTION: 'Tampilkan dalam garis waktu',
    OVERVIEW_PERFORMANCE_TRACKER_EXP: 'Pengaturan ini memiliki dampak kinerja',
    OVERVIEW_PERFORMANCE_TRACKER_EXP2: 'kecil',
    OVERVIEW_PERFORMANCE_TRACKER_EXP3: 'ketika Anda memuat (kembali) garis waktu pengguna. Hal ini mempengaruhi ringkasan, membandingkan dan halaman profil bersama.',
    OVERVIEW_PERFORMANCE_SAVE: 'Simpan pengaturan',
    OVERVIEW_PERFORMANCE_CLOSE: 'Tutup',
    COMPARE_SELECT: 'Memilih kandidat',
    COMPARE_ADD_TO_COMPARE: 'Tambahkan pengguna ke perbandingan',
    COMPARE_ADD: 'Tambah',
    COMPARE_ADD_GROUP_COMPARE: 'Tambahkan kelompok ke perbandingan',
    COMPARE_ADD_NOTICE: 'Memuatkan kelompok besar dapat menyebabkan browser beku karena terlalu banyak informasi.',
    COMPARE_CURR_LIST: 'Kandidat saat ini dalam perbandingan:',
    COMPARE_CURR_LIST_INFO: 'Kandidat / Pengaturan privasi',
    COMPARE_LASTSEEN: 'terakhir terlihat :',
    COMPARE_STATUSMSG: 'pesan-pesan status :',
    COMPARE_PROFPIC: 'Gambar profil :',
    COMPARE_REMOVE: 'Hapus',
    COMPARE_LOADING: 'Memuatkan informasi akun ...',
    COMPARE_CONTACTS: 'kontak*',
    COMPARE_EVERYBODY: 'semua orang',
    COMPARE_CONTACTS_NOTICE: 'Pengaturan privasi ini mungkin adalah kontak atau tanpa orang. Ini tidak dapat dideteksi.',
    STATS_TOKEN_INFO: 'Anda tidak mengizinkan untuk melihat kelompok ini karena token adalah atau menjadi tidak valid.',
    STATS_TOKEN_GROUP: 'Profil kelompok bersama:',
    STATS_TOKEN_GROUP_INFO: 'Ini adalah laporan statistik kelompok yang dibagi',
    STATS_TOKEN_GROUP_INFO2: 'dibuat oleh hoster dari contoh WhatsSpy Publik.',
    STATS_NO_INFO: 'Tidak cukup informasi yang tersedia ...',
    STATS_LOADING: 'Memuatkan informasi ...',
    STATS_FILTER: 'Pilihan filter',
    STATS_NOTES: 'Catatan',
    STATS_INFO_VALIDITY: 'Semua informasi pada halaman ini tidak memperbarui. Anda dapat klik penanda abu-abu dalam "status" untuk mengyegarkan.',
    STATS_TOKEN_GEN: 'Buat',
    STATS_TOKEN_RESET: 'Reset',
    STATS_SHARE_INFO: 'Berbagi halaman URL kelompok statistik dapat berkerja hanya jika WhatsSpy Publik tersedia dari internet. Mengkilk token untuk menyalin link.',
    STATS_H: 'Statistik WhatsSpy Publik',
    STATS_TRACKER_STATUS: 'Status Pelacak',
    STATS_SESSION: 'Sesi Pelacak',
    STATS_FIRST_SESSION: 'Sesi pelacak pertama (sejak aliran informasi mulai)',
    STATS_DB_CONTENT: 'Isi database',
    STATS_NUMBER_OF_ACC: 'Jumlah nomor akun',
    STATS_ACCOUNTS: 'Akun',
    STATS_STATUSES: 'status-status',
    STATS_PROFPIC: 'gambar profil',
    STATS_STSMSG: 'pesan-pesan status',
    STATS_H_ONLINE: 'Status-status online/offline dikumpulkan',
    STATS_H_TOTALTIME: 'Jumlah waktu yang dihabiskan pada WhatsApp oleh semua kontak',
    STATS_H_PROFPICSUM: 'Gambar profil dikumpulkan',
    STATS_H_STATUSMSGSUM: 'Pesan-pesan Status dikumpulkan',
    STATS_H_PRIVACY: 'Kesadaran privasi',
    STATS_PRIVACY_H: 'Pengaturan privasi pengguna dilacak',
    STATS_PRIVACY_TABLE_TH1: 'Pilihan privasi',
    STATS_PRIVACY_TABLE_TH2: 'kontak/tanpa orang',
    STATS_PRIVACY_TABLE_TH3: 'semua orang',
    STATS_PRIVACY_OPTION1: 'terakhir terlihat*',
    STATS_PRIVACY_OPTION2: 'Pesan-pesan status',
    STATS_PRIVACY_OPTION3: 'Gambar profil',
    STATS_PRIVACY_USERS: 'pengguna',
    STATS_PRIVACY_HISTORY: 'Perubahan privasi sementara pelacakan',
    STATS_PRIVACY_LASTSEEN: 'Perubahan privasi terakhir terlihat',
    STATS_PRIVACY_CHANGE: 'perubahan',
    STATS_PRIVACY_PROFPIC: 'Perubahan privasi gambar profil',
    STATS_PRIVACY_STATUSMSG: 'Perubahan privasi pesan status',
    STATS_PRIVACY_INFO1: '* Pilihan terakhir terlihat tidak melindungi Anda terhadap pelacakan status online/offline. Memeriksa',
    STATS_PRIVACY_INFO2: 'artikel ini',
    STATS_PRIVACY_INFO3: 'yang menjelaskan masalah secara rinci.',
    STATS_PIE_CHART_ONLINE_TIME_H: 'Pemakaian WhatsApp (waktu online / membuka) dibandingkan per pengguna',
    STATS_PIE_CHART_TODAY: 'Tampilkan hari ini',
    STATS_PIE_CHART_7DAYS: 'Tampilkan 7 hari',
    STATS_PIE_CHART_14DAYS: 'Tampilkan 14 hari',
    STATS_PIE_CHART_ALL: 'Tampilkan semua',
    STATS_PIE_CHART_PIE_OPEN_H_ALL: 'Membuka WhatsApp - Semua',
    STATS_PIE_CHART_PIE_OPEN_H_7DAYS: 'Membuka WhatsApp - 7 hari terakhir',
    STATS_PIE_CHART_PIE_OPEN_H_14DAYS: 'Membuka WhatsApp - 14 hari terakhir',
    STATS_PIE_CHART_PIE_OPEN_H_TODAY: 'Membuka WhatsApp - Hari ini',
    STATS_PIE_CHART_PIE_ONLINE_H_ALL: 'Waktu online di WhatsApp - Semua',
    STATS_PIE_CHART_PIE_ONLINE_H_7DAYS: 'Waktu online di WhatsApp - 7 hari terakhir',
    STATS_PIE_CHART_PIE_ONLINE_H_14DAYS: 'Waktu online di WhatsApp - 14 hari terakhir',
    STATS_PIE_CHART_PIE_ONLINE_H_TODAY: 'Waktu online di WhatsApp - Hari ini',
    STATS_PIE_CHART_PIE_INFO: 'Harap dicatat bahwa setiap sesi online mungkin salah 0-4 detik berdasarkan WhatsApp, mesin dan aktivitas jaringan Anda. Ini berarti semua data adalah waktu maksimum yang mereka habiskan di WhatsApp.',
    STATS_PIE_CHART_BAR_H: 'Pemakaian WhatsApp (waktu online / membuka) dibandingkan persatuan waktu',
    STATS_PIE_CHART_BAR_OPEN_H_WEEKDAY: 'Membuka WhatsApp per minggu hari',
    STATS_PIE_CHART_BAR_OPEN_H_HOUR: 'Membuka WhatsApp per jam',
    STATS_PIE_CHART_BAR_SHOWHOUR: 'Tampilkan per jam',
    STATS_PIE_CHART_BAR_SHOWWEEKDAY: 'Tampilkan per minggu hari',
    STATS_PIE_CHART_BAR_TIME_H_WEEKDAY: 'Waktu di WhatsApp per minggu hari',
    STATS_PIE_CHART_BAR_TIME_H_HOUR: 'Waktu di WhatsApp per jam',
    STATS_BAR_CHART_TODAY: 'hari ini',
    STATS_BAR_CHART_7DAYS: '7 hari',
    STATS_BAR_CHART_14DAYS: '14 hari',
    STATS_BAR_CHART_ALLTIME: 'Jumlah waktu',
    STATS_TOP_H1: 'Atas',
    STATS_TOP_H2: 'pengguna dilacak',
    STATS_TOP_ALL_SHOW: 'Tampilkan semua',
    STATS_TOP_H3: 'Pengguna yang paling aktif per hari',
    STATS_TOP_DAYS_AGO: 'hari terakhir',
    STATS_TOP_YESTERDAY: 'Kemarin',
    STATS_TOP_TODAY: 'Hari ini',
    STATS_TOP_TRACKED_CONTACT: 'Kontak dilacak',
    STATS_TOP_TIME: 'Waktu online',
    STATS_TOP_OPENED: 'Telah membuka WA',
    STATS_TOP_TIMES: 'kali',
    STATS_TOP_H4: 'Jumlah pengguna yang paling aktif',
    STATS_TOP_ALL: 'Semua',
    STATS_TOP_DAYS: 'hari',
    STATS_TOP_HOURS: 'jam',
    STATS_TYPE_today: 'hari ini',
    STATS_TYPE_yesterday: 'kemarin',
    STATS_TYPE_2days_ago: '2 hari terakhir',
    STATS_TYPE_3days_ago: '3 hari terakhir',
    STATS_TYPE_4days_ago: '4 hari terakhir',
    STATS_TYPE_alltime: 'jumlah waktu',
    STATS_TYPE_31days: '31 hari',
    STATS_TYPE_14days: '14 hari',
    STATS_TYPE_7days: '7 hari',
    STATS_TYPE_24hours: '24 jam',
    TIMELINE_FILTER: 'Filters',
    TIMELINE_FILTER_PHONE_PLACEHOLDER: 'Mencari dengan nomor telepon ...',
    TIMELINE_FILTER_NAME_PLACEHOLDER: 'Gunakan nama|nama untuk menyaring pada berberapa nama.',
    TIMELINE_SEARCH_NAME: 'Mencari dengan nama ...',
    TIMELINE_INFO_STATUS: 'Sistem sedang memeriksa semua status',
    TIMELINE_INFO_FROM: 'dari',
    TIMELINE_INFO_CONTACTS: 'kontak',
    TIMELINE_INFO_CONTINIOUS: 'terus-menurus sejak',
    TIMELINE_INFO_LASTSTATUS: 'Kontak dengan "terakhir terlihat" yang diatur ke "tanpa orang" akan',
    TIMELINE_INFO_LASTSTATUS2: 'dilacak tetap',
    TIMELINE_INFO_LIVE: 'Unlike the overview and comparison page, informasi ini is live.',
    TIMELINE_FILTER_NOTIFY: 'Notify for any event (dengan filter)',
    TIMELINE_FILTER_TRACKER: 'Tampilkan pelacak events',
    TIMELINE_ACTIVITY_H: 'Kegiatan Timeline',
    TIMELINE_STATUS_H: 'Status Waktu',
    TIMELINE_ACTIVITY_TIMESPAN1: 'Kegiatan waktu',
    TIMELINE_ACTIVITY_TIMESPAN2: 'dari',
    TIMELINE_ACTIVITY_TIMESPAN3: 'sampai sekarang',
    TIMELINE_ACTIVITY_TRACKERSTART: 'Pelacak sekarang online',
    TIMELINE_ACTIVITY_TRACKERSTART_STARTED: 'mulai pada',
    TIMELINE_ACTIVITY_TRACKERSTOP: 'Pelacak sekarang offline',
    TIMELINE_ACTIVITY_TRACKERSTOP_SESSION: 'sesi ini berlangsung pada',
    TIMELINE_ACTIVITY_TRACKERSTOP_TILL: 'sampai',
    TIMELINE_ACTIVITY_TRACKERSTOP_REASON: 'Alasan:',
    TIMELINE_ACTIVITY_TRACKERSTOP_SUPPORT: 'Support untuk masalah umum',
    TIMELINE_ACTIVITY_STATUSMSG: 'Pesan status baru untuk',
    TIMELINE_ACTIVITY_STATUSMSG_TO: 'merubah ke',
    TIMELINE_ACTIVITY_PROFPIC: 'Foto profil baru untuk',
    TIMELINE_ACTIVITY_PROFPIC_TITLE: 'Mendeteksi perubahan gambar profil mungkin perlu 0-4 jam.',
    TIMELINE_ACTIVITY_PRIV: 'mengubah pengaturan privasinya',
    TIMELINE_ACTIVITY_PRIV_OPTION: 'Pilihan privasi',
    TIMELINE_ACTIVITY_PRIV_LASTSEEN: 'terakhir terlihat',
    TIMELINE_ACTIVITY_PRIV_SETTO: 'sekarang sudah siap untuk',
    TIMELINE_ACTIVITY_PRIV_CONTACTS: 'kontak*',
    TIMELINE_ACTIVITY_PRIV_EVERYONE: 'semua orang',
    TIMELINE_ACTIVITY_PRIV_CONTACTSTITLE: 'Pengaturan privasi ini mungkin adalah kontak atau tanpa orang. Ini tidak dapat dideteksi.',
    TIMELINE_ACTIVITY_PRIV_PROFPIC: 'gambar profil',
    TIMELINE_ACTIVITY_PRIV_STATUSMSG: 'pesan-pesan status',
    TIMELINE_ACTIVITY_NOINFO: 'Belum ada informasi yang tersedia ..',
    TIMELINE_ACTIVITY_LOADMORE: 'Klik untuk memuat 7 hari lagi catatan yang lebih lama ..',
    TIMELINE_STATUS_ONLINE: 'Online pada',
    TIMELINE_STATUS_TILL: 'sampai',
    TIMELINE_STATUS_NOINFO: 'Tidak ada informasi yang tersedia ..',
    TIMELINE_STATUS_NOINFOFILTER: 'Tidak ada status pengguna terbaru untuk saringan ini ..',
    ABOUT_LICENSE0: 'WhatsSpy Publik adalak Bukti Konsep untuk menunjukkan bagaimana rusak pengaturan privasi Whatsapp. Dengan alat ini Anda pada dasarnya dapat mengikuti siapa pun perlilaku dengan hanya pengetahuan nomor telepon mereka. Alat ini hanya untuk Bukti Konsep saja! Silahkan baca',
    ABOUT_LICENSE1: 'lisensi',
    ABOUT_LICENSE2: 'yang berlaku Bukti Konsep ini.',
    ABOUT_DONATION0: 'Anda dapat mendukung pekerjaan ini melalui sumbungan kecil:',
    ABOUT_DONATION1: 'Bitcoin:',
    ABOUT_DONATION2: 'atau melalui',
    ABOUT_DONATION3: 'Paypal',
    ABOUT_INFO: 'Informasi Umum',
    ABOUT_VERSION: 'Menjalankan versi:',
    ABOUT_UPDATE: 'tersedia.',
    ABOUT_UPTODATE: 'Versi Anda terkini.',
    ABOUT_UPDATE_NOW: 'Memperbaruhi',
    ABOUT_UPDATE_LOG: 'Log pembaruan dan bagaimana-memperbaruhi',
    ABOUT_WIKI: 'Wiki halaman rumah:',
    ABOUT_WIKI_LINK: 'Gitlab Wiki',
    ABOUT_FAQ: 'FAQ:',
    ABOUT_FAQ_LINK: 'Pertanyaan yang Sering Diajukan',
    ABOUT_TROUBLE: 'Penyelesaian masalah:',
    ABOUT_TROUBLE_LINK: 'Penyelesaian masalah',
    ABOUT_OPTIONS: 'Pilihan:',
    ABOUT_OPTIONS_LOGOUT: 'Logout WebUI',
    ABOUT_LANGUAGE: 'Bahasa Klien:',
    ABOUT_ADVANCED: 'Pilihan maju:',
    ABOUT_ADVANCED_STOP: 'Menghentikan Pelacak',
    ABOUT_ADVANCED_START: 'Memulai Pelacak',
    ABOUT_ADVANCED_UPDATE: 'Perbaruan otomatis',
    ABOUT_NEWS: 'Bacaan/berita untuk proyek ini:',
    ABOUT_AGENTS: 'Agen permberitahuan',
    ABOUT_AGENTS_NONE1: 'Tidak ada agen pemberitahuan dikonfigurasi di',
    ABOUT_AGENTS_NONE2: 'config.php',
    ABOUT_AGENTS_NONE3: 'Memeriksa config.example.php jika Anda kehilangan pilihan ini.',
    ABOUT_AGENTS_PROPS: 'Memberitahukan sifat:',
    ABOUT_AGENTS_USER: 'Tindakan pengguna',
    ABOUT_AGENTS_TRACKER: 'Tindakan pelacak',
    ABOUT_AGENTS_TO: 'ke:',
    ABOUT_AGENTS_RESTART: 'Ingat memulai kembali pelacak setelah setiap perubahan dalam config.php Anda.',
    ABOUT_QA: 'Pertanyaan dan Jawaban',
    CONTROLLER_TIMELINE_1D: '24 jam (kinerja terbaik)',
    CONTROLLER_TIMELINE_7D: '7  hari',
    CONTROLLER_TIMELINE_14D: '14 hari',
    CONTROLLER_TIMELINE_31D: '31 hari (lambat)',
    CONTROLLER_TIMELINE_90D: '90 days (sangat lambat)',
    CONTROLLER_CHAR_OPENED: 'dibuka',
    CONTROLLER_CHAR_TIMES: 'kali',
    CONTROLLER_CHAR_MINUTES: 'menit',
    CONTROLLER_COPY: 'Salin ke clipboard: Ctrl+C, Enter',
    CONTROLLER_WEEKDAY_Sunday: 'Minggu',
    CONTROLLER_WEEKDAY_Monday: 'Isnin',
    CONTROLLER_WEEKDAY_Tuesday: 'Selasa',
    CONTROLLER_WEEKDAY_Wednesday: 'Rabu',
    CONTROLLER_WEEKDAY_Thursday: 'Kamis',
    CONTROLLER_WEEKDAY_Friday: 'Jumaat',
    CONTROLLER_WEEKDAY_Saturday: 'Sabtu',
    CONTROLLER_NONAME: 'Tanpa nama',
    CONTROLLER_NOTOKEN: 'Tidak dibagi ...',
    CONTROLLER_TRACKER_REASON_NONE: 'tidak diberikan',
    CONTROLLER_TIME_DAY: 'hari ',
    CONTROLLER_TIME_HOURS: 'jam ',
    CONTROLLER_TIME_MINUTES: 'men ',
    CONTROLLER_TIME_SECONDS: 'detik',
    CONTROLLER_SERVER_NO_RES: 'Tidak dapat menyambung server.',
    CONTROLLER_GROUP_NEW: 'Masukkan nama baru untuk kelompok ini:',
    CONTROLLER_ACCOUNT_DEL: 'Apakah Anda yakin Anda ingin menghapus Akun ini?',
    CONTROLLER_ACCOUNT_REMOVED: ' dihapus!',
    CONTROLLER_ACCOUNT_UPDATED: 'Kontak diperbaruhi',
    CONTROLLER_ACCOUNT_ADDED: 'Kontak ditambahkan ke WhatsSpy. Pelacakan akan mulai pada 5-10 menit.',
    CONTROLLER_ACCOUNT_INACTIVE: ' mengatur non-aktif!',
    CONTROLLER_GROUP_SAVE: 'Kelompok nama baru tersimpan!',
    CONTROLLER_GROUP_ADD: 'Kelompok baru ditambahkan.',
    CONTROLLER_GROUP_DEL: 'Kelompok dihapus.',
    CONTROLLER_CONFIG_UPDATE: 'Konfigurasi diperbarui',
    CONTROLLER_TIME_DAY_FULL: 'hari',
    CONTROLLER_TIME_WEEK_FULL: 'minggu',
    CONTROLLER_TIME_MONTH_FULL: 'bulan',
    CONTROLLER_TIME_CUSTOM_FULL: 'custom',
    CONTROLLER_TIMELINE_HISTORY: 'Pandangan sejarah:',
    CONTROLLER_TIMELINE_DAYS: 'hari',
    CONTROLLER_TIMELINE_ONLINE: 'Online',
    CONTROLLER_TIMELINE_DURATION: 'Durasi:',
    CONTROLLER_COMPARISON_ALREADY_IN: ' sudah dalam perbandingan!',
    CONTROLLER_NOTIFICATION_ONLINE: ' sekarang online.',
    CONTROLLER_NOTIFICATION_STATUSMSG: ' ada pesan status baru: ',
    CONTROLLER_NOTIFICATION_PROFPIC: ' ada gambar profil baru.',
    CONTROLLER_NOTIFICATION_PIRV_EVERY: 'semua orang',
    CONTROLLER_NOTIFICATION_PRIV_CONTACTS: 'kontak atau tanpa orang',
    CONTROLLER_NOTIFICATION_PRIV_LASTSEEN: ' telah merubah pengaturan privasi terakhir terlihat ke ',
    CONTROLLER_NOTIFICATION_PRIV_PROFPIC: ' telah merubah pengaturan privasi gambar profil ke ',
    CONTROLLER_NOTIFICATION_PRIV_STATUSMSG: ' telah merubah pengaturan pribadi pesan status ke ',
    CONTROLLER_NOTIFICATION_TRACKER_START: 'Pelacak memulai pelacakan.',
    CONTROLLER_NOTIFICATION_TRACKER_STOP: 'Pelacak menghentikan pelacakan dengan alasan: ',
    CONTROLLER_STAT_TIMES: 'kali',
    CONTROLLER_CMD0: 'CMD: ',
    CONTROLLER_CMD1: ' mengakibatkan kode: ',
    CONTROLLER_CMD2: ' dengan keluaran: ',
    PRIVACY_STATUS_EVERYONE: 'semua orang',
    PRIVACY_STATUS_CONTACTS_OR_NOBODY: 'kontak atau tanpa orang'
    });
    moment.locale('id', {
        months : [
            "Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli",
            "Agustus", "September", "Oktober", "November", "Desember"
        ],
        monthsShort : [
            "Jan", "Feb", "Mar", "Apr", "Mei", "Jun",
            "Jul", "Agu", "Sep", "Okt", "Nov", "Des"
        ],
        weekdays : [
            "Minggu", "Isnin", "Selasa", "Rabu", "Kamis", "Jumaat", "Sabtu"
        ],
        weekdaysShort : [
            "Min", "Isn", "Sel", "Rab", "Kam", "Jum", "Sab"
        ],
        longDateFormat : {
            LT: "h:mm A",
            LTS: "h:mm:ss A",
            L: "MM/DD/YYYY",
            l: "M/D/YYYY",
            LL: "MMMM Do YYYY",
            ll: "MMM D YYYY",
            LLL: "MMMM Do YYYY LT",
            lll: "MMM D YYYY LT",
            LLLL: "dddd, MMMM Do YYYY LT",
            llll: "ddd, MMM D YYYY LT"
        },
        relativeTime : {
            future: "dalam %s",
            past:   "%s silam",
            s:  "detik",
            m:  "satu menit",
            mm: "%d menit",
            h:  "satu jam",
            hh: "%d jam",
            d:  "satu hari",
            dd: "%d hari",
            M:  "satu bulan",
            MM: "%d bulan",
            y:  "satu tahun",
            yy: "%d tahun"
        }
    });


    $translateProvider.useSanitizeValueStrategy('escape');
    availableLanguages = [
        {
            id:'en',
            name: 'English'
        },
        {
            id: 'nl',
            name: 'Dutch'
        },
        {
            id: 'de',
            name: 'German (translator: Robin Kluth)'
        },
        {
            id:'es',
            name: 'Spanish (translator: Javier Andres Tolosa Rivera)'
        },
        {
            id:'zh-cn',
            name: 'Simplified Chinese 简体中文 (translator: Edwin Seah Poh San)'
        },
        {
            id:'id',
            name: 'Bahasa Indonesia (translator: Edwin Seah Poh San)'
        }];


    // Check if cookie exist, otherwise choose english.
    var cookieLang = getCookie('WSlanguage');
    if(cookieLang != undefined) {
        $translateProvider.preferredLanguage(cookieLang);
        moment.locale(cookieLang);
    } else {
        var language = 'en';
        $translateProvider.preferredLanguage(language);
        moment.locale(language);
    }
}]);